/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.SystemDeleteTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;
import java.time.Instant;

public final class SystemDeleteTransaction
extends TransactionBuilder<SystemDeleteTransaction> {
    private final SystemDeleteTransactionBody.Builder builder;

    public SystemDeleteTransaction() {
        this.builder = this.bodyBuilder.getSystemDeleteBuilder();
    }

    public SystemDeleteTransaction setFileId(FileId fileId) {
        this.builder.setFileID(fileId.toProto());
        return this;
    }

    public SystemDeleteTransaction setContractId(ContractId contractId) {
        this.builder.setContractID(contractId.toProto());
        return this;
    }

    public SystemDeleteTransaction setExpirationTime(Instant timestamp) {
        this.builder.setExpirationTime(TimestampHelper.timestampSecondsFrom(timestamp));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return FileServiceGrpc.getSystemDeleteMethod();
    }

    @Override
    protected void doValidate() {
        this.requireExactlyOne(".setID() required", ".setID() may take a contract ID OR a file ID", this.builder.hasContractID(), this.builder.hasFileID());
    }
}

