/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionBody;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaCall;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaPrecheckStatusException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.account.AccountId;
import io.grpc.Channel;
import java.time.Duration;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class TransactionBuilder<T extends TransactionBuilder<T>>
extends HederaCall<com.hedera.hashgraph.proto.Transaction, TransactionResponse, TransactionId, T> {
    protected final Transaction.Builder inner = com.hedera.hashgraph.proto.Transaction.newBuilder();
    protected final TransactionBody.Builder bodyBuilder = TransactionBody.newBuilder();
    private static final int MAX_MEMO_LENGTH = 100;
    private Duration validDuration;

    public TransactionBuilder() {
        this.setTransactionValidDuration(Transaction.MAX_VALID_DURATION);
        this.validDuration = Transaction.MAX_VALID_DURATION;
    }

    public T setTransactionId(TransactionId transactionId) {
        this.bodyBuilder.setTransactionID(transactionId.toProto());
        return this.self();
    }

    public final T setNodeAccountId(AccountId accountId) {
        this.bodyBuilder.setNodeAccountID(accountId.toProto());
        return this.self();
    }

    public final T setMaxTransactionFee(Hbar fee) {
        this.bodyBuilder.setTransactionFee(fee.asTinybar());
        return this.self();
    }

    public final T setMaxTransactionFee(long fee) {
        this.bodyBuilder.setTransactionFee(fee);
        return this.self();
    }

    public final T setTransactionValidDuration(Duration validDuration) {
        Duration actual = validDuration;
        if (Transaction.MAX_VALID_DURATION.compareTo(validDuration) < 0) {
            actual = Transaction.MAX_VALID_DURATION;
        }
        this.bodyBuilder.setTransactionValidDuration(DurationHelper.durationFrom(actual));
        this.validDuration = actual;
        return this.self();
    }

    public final T setTransactionMemo(String memo) {
        if (memo.length() > 100) {
            throw new IllegalArgumentException("memo must not be longer than 100 characters");
        }
        this.bodyBuilder.setMemo(memo);
        return this.self();
    }

    protected abstract void doValidate();

    @Override
    public final com.hedera.hashgraph.proto.Transaction toProto() {
        return this.build(null).toProto();
    }

    @Internal
    public final com.hedera.hashgraph.proto.Transaction toProto(boolean requireSignature) {
        return this.build(null).toProto(requireSignature);
    }

    @Override
    protected final void localValidate() {
        TransactionBody.Builder bodyBuilder = this.bodyBuilder;
        this.require(bodyBuilder.hasTransactionID(), ".setTransactionId() required");
        this.require(bodyBuilder.hasNodeAccountID(), ".setNodeAccountId() required");
        this.doValidate();
        this.checkValidationErrors("transaction builder failed local validation");
    }

    public final Transaction build(@Nullable Client client) throws LocalValidationException {
        if (client != null && this.bodyBuilder.getTransactionFee() == 0L) {
            this.setMaxTransactionFee(client.getMaxTransactionFee());
        }
        if (!this.bodyBuilder.hasNodeAccountID()) {
            Node channel;
            Node node = channel = client != null ? client.pickNode() : null;
            if (channel != null) {
                this.bodyBuilder.setNodeAccountID(channel.accountId.toProto());
            }
        }
        if (!this.bodyBuilder.hasTransactionID() && client != null && client.getOperatorId() != null) {
            this.bodyBuilder.setTransactionID(new TransactionId(client.getOperatorId()).toProto());
        }
        this.localValidate();
        this.inner.setBodyBytes(this.bodyBuilder.build().toByteString());
        return new Transaction(this.inner, this.bodyBuilder, this.getMethod());
    }

    @Override
    public TransactionId execute(Client client, Duration retryTimeout) throws HederaStatusException, HederaNetworkException {
        return this.build(client).execute(client, retryTimeout);
    }

    @Override
    public void executeAsync(Client client, Duration retryTimeout, Consumer<TransactionId> onSuccess, Consumer<HederaThrowable> onError) {
        this.build(client).executeAsync(client, retryTimeout, onSuccess, onError);
    }

    private T self() {
        return (T)this;
    }

    @Override
    protected Duration getDefaultTimeout() {
        return this.validDuration;
    }

    @Override
    protected Channel getChannel(Client client) {
        if (this.bodyBuilder.hasNodeAccountID()) {
            return client.getNodeForId(new AccountId(this.bodyBuilder.getNodeAccountID())).getChannel();
        }
        return client.pickNode().getChannel();
    }

    @Override
    protected TransactionId mapResponse(TransactionResponse response) throws HederaStatusException {
        TransactionId transactionId = new TransactionId(this.bodyBuilder.getTransactionIDOrBuilder());
        HederaPrecheckStatusException.throwIfExceptional(response.getNodeTransactionPrecheckCode(), transactionId);
        return transactionId;
    }
}

