/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.Timestamp;
import com.hedera.hashgraph.proto.TransactionID;
import com.hedera.hashgraph.proto.TransactionIDOrBuilder;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaReceiptStatusException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import com.hedera.hashgraph.sdk.account.AccountId;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class TransactionId {
    public final AccountId accountId;
    public final Instant validStart;
    private final TransactionID.Builder inner;
    @Nullable
    private static Instant lastInstant;

    private TransactionId(AccountId accountId, Instant transactionValidStart) {
        this.inner = TransactionID.newBuilder().setAccountID(accountId.toProto()).setTransactionValidStart(Timestamp.newBuilder().setSeconds(transactionValidStart.getEpochSecond()).setNanos(transactionValidStart.getNano()));
        this.accountId = accountId;
        this.validStart = transactionValidStart;
    }

    public TransactionId(AccountId accountId) {
        this(accountId, TransactionId.getIncreasingInstant());
    }

    public static TransactionId withValidStart(AccountId accountId, Instant transactionValidStart) {
        return new TransactionId(accountId, transactionValidStart);
    }

    TransactionId(TransactionIDOrBuilder transactionId) {
        this.inner = TransactionID.newBuilder().setAccountID(transactionId.getAccountID()).setTransactionValidStart(transactionId.getTransactionValidStart());
        this.accountId = new AccountId(transactionId.getAccountIDOrBuilder());
        this.validStart = TimestampHelper.timestampTo(transactionId.getTransactionValidStart());
    }

    @Internal
    public TransactionID toProto() {
        return this.inner.build();
    }

    public String toString() {
        Timestamp timestampProto = TimestampHelper.timestampFrom(this.validStart);
        return this.accountId.toString() + "@" + timestampProto.getSeconds() + "." + timestampProto.getNanos();
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.validStart);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransactionId)) {
            return false;
        }
        TransactionId otherId = (TransactionId)other;
        return this.accountId.equals(otherId.accountId) && this.validStart.equals(otherId.validStart);
    }

    void waitForConsensus(Client client, @Nullable Duration timeout) throws HederaStatusException {
        block4: {
            try {
                if (timeout != null) {
                    this.getReceipt(client, timeout);
                } else {
                    this.getReceipt(client);
                }
            }
            catch (HederaReceiptStatusException e) {
                if (!e.status.equalsAny(Status.Busy, Status.Unknown)) break block4;
                throw e;
            }
        }
    }

    void waitForConsensusAsync(Client client, @Nullable Duration timeout, Runnable onSuccess, Consumer<HederaThrowable> onError) {
        Consumer<HederaThrowable> onError2 = e -> {
            if (e instanceof HederaReceiptStatusException) {
                if (((HederaReceiptStatusException)e).status.equalsAny(Status.Busy, Status.Unknown)) {
                    onError.accept((HederaThrowable)e);
                } else {
                    onSuccess.run();
                }
            }
        };
        if (timeout != null) {
            this.getReceiptAsync(client, timeout, r -> onSuccess.run(), onError2);
        } else {
            this.getReceiptAsync(client, r -> onSuccess.run(), onError2);
        }
    }

    public TransactionReceipt getReceipt(Client client) throws HederaStatusException {
        return (TransactionReceipt)new TransactionReceiptQuery().setTransactionId(this).execute(client);
    }

    public TransactionReceipt getReceipt(Client client, Duration timeout) throws HederaStatusException {
        return (TransactionReceipt)new TransactionReceiptQuery().setTransactionId(this).execute(client, timeout);
    }

    public void getReceiptAsync(Client client, Consumer<TransactionReceipt> onReceipt, Consumer<HederaThrowable> onError) {
        new TransactionReceiptQuery().setTransactionId(this).executeAsync(client, onReceipt, onError);
    }

    public void getReceiptAsync(Client client, Duration timeout, Consumer<TransactionReceipt> onReceipt, Consumer<HederaThrowable> onError) {
        new TransactionReceiptQuery().setTransactionId(this).executeAsync(client, timeout, onReceipt, onError);
    }

    public TransactionRecord getRecord(Client client) throws HederaStatusException, HederaNetworkException {
        this.waitForConsensus(client, null);
        return (TransactionRecord)new TransactionRecordQuery().setTransactionId(this).execute(client);
    }

    public TransactionRecord getRecord(Client client, Duration timeout) throws HederaStatusException {
        this.waitForConsensus(client, timeout);
        return (TransactionRecord)new TransactionRecordQuery().setTransactionId(this).execute(client, timeout);
    }

    public void getRecordAsync(Client client, Consumer<TransactionRecord> onRecord, Consumer<HederaThrowable> onError) {
        this.waitForConsensusAsync(client, null, () -> new TransactionRecordQuery().setTransactionId(this).executeAsync(client, onRecord, onError), onError);
    }

    public void getRecordAsync(Client client, Duration timeout, Consumer<TransactionRecord> onRecord, Consumer<HederaThrowable> onError) {
        this.waitForConsensusAsync(client, timeout, () -> new TransactionRecordQuery().setTransactionId(this).executeAsync(client, timeout, onRecord, onError), onError);
    }

    private static synchronized Instant getIncreasingInstant() {
        Instant instant = Clock.systemUTC().instant().minusSeconds(10L);
        lastInstant = lastInstant != null && instant.compareTo(lastInstant) <= 0 ? lastInstant.plusNanos(1L) : instant;
        return lastInstant;
    }
}

