/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TransactionGetReceiptQuery;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import io.grpc.MethodDescriptor;
import java.time.Duration;

public final class TransactionReceiptQuery
extends QueryBuilder<TransactionReceipt, TransactionReceiptQuery> {
    private final TransactionGetReceiptQuery.Builder builder;

    public TransactionReceiptQuery() {
        this.builder = this.inner.getTransactionGetReceiptBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.inner.getTransactionGetReceiptBuilder().getHeaderBuilder();
    }

    public TransactionReceiptQuery setTransactionId(TransactionId transactionId) {
        this.builder.setTransactionID(transactionId.toProto());
        return this;
    }

    @Override
    protected boolean shouldRetry(HederaThrowable e) {
        if (!(e instanceof HederaStatusException)) {
            return false;
        }
        switch (((HederaStatusException)e).status) {
            case Unknown: 
            case Ok: 
            case ReceiptNotFound: 
            case Busy: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getGetTransactionReceiptsMethod();
    }

    @Override
    protected TransactionReceipt extractResponse(Response raw) {
        return new TransactionReceipt(raw);
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasTransactionID(), ".setTransactionId() required");
    }

    @Override
    protected Duration getDefaultTimeout() {
        return Transaction.MAX_VALID_DURATION.plus(Duration.ofMinutes(3L));
    }

    @Override
    protected boolean isPaymentRequired() {
        return false;
    }
}

