/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TransactionGetRecordQuery;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionRecord;
import io.grpc.MethodDescriptor;

public class TransactionRecordQuery
extends QueryBuilder<TransactionRecord, TransactionRecordQuery> {
    private final TransactionGetRecordQuery.Builder builder;

    public TransactionRecordQuery() {
        this.builder = this.inner.getTransactionGetRecordBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public TransactionRecordQuery setTransactionId(TransactionId transaction) {
        this.builder.setTransactionID(transaction.toProto());
        return this;
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getGetTxRecordByTxIDMethod();
    }

    @Override
    protected TransactionRecord extractResponse(Response raw) {
        return new TransactionRecord(raw.getTransactionGetRecord().getTransactionRecord());
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasTransactionID(), ".setTransactionId() required");
    }
}

