/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoGetStakersQuery;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.account.AccountProxyStaker;
import io.grpc.MethodDescriptor;
import java.util.List;
import java.util.stream.Collectors;

public final class AccountStakersQuery
extends QueryBuilder<List<AccountProxyStaker>, AccountStakersQuery> {
    private final CryptoGetStakersQuery.Builder builder;

    public AccountStakersQuery() {
        this.builder = this.inner.getCryptoGetProxyStakersBuilder();
    }

    public AccountStakersQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProto());
        return this;
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasAccountID(), ".setAccountId() required");
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getGetStakersByAccountIDMethod();
    }

    @Override
    protected List<AccountProxyStaker> extractResponse(Response raw) {
        return raw.getCryptoGetProxyStakers().getStakers().getProxyStakerList().stream().map(AccountProxyStaker::new).collect(Collectors.toList());
    }
}

