/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.google.protobuf.BoolValue;
import com.google.protobuf.UInt64Value;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.CryptoUpdateTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public final class AccountUpdateTransaction
extends TransactionBuilder<AccountUpdateTransaction> {
    private final CryptoUpdateTransactionBody.Builder builder;

    public AccountUpdateTransaction() {
        this.builder = this.bodyBuilder.getCryptoUpdateAccountBuilder();
    }

    public AccountUpdateTransaction setAccountId(AccountId accountId) {
        this.builder.setAccountIDToUpdate(accountId.toProto());
        return this;
    }

    public AccountUpdateTransaction setKey(PublicKey key) {
        this.builder.setKey(key.toKeyProto());
        return this;
    }

    public AccountUpdateTransaction setProxyAccountId(AccountId accountId) {
        this.builder.setProxyAccountID(accountId.toProto());
        return this;
    }

    public AccountUpdateTransaction setSendRecordThreshold(long sendRecordThreshold) {
        this.builder.setSendRecordThresholdWrapper(UInt64Value.of((long)sendRecordThreshold));
        return this;
    }

    public AccountUpdateTransaction setSendRecordThreshold(Hbar sendRecordThreshold) {
        this.builder.setSendRecordThresholdWrapper(UInt64Value.of((long)sendRecordThreshold.asTinybar()));
        return this;
    }

    public AccountUpdateTransaction setReceiveRecordThreshold(long receiveRecordThreshold) {
        this.builder.setReceiveRecordThresholdWrapper(UInt64Value.of((long)receiveRecordThreshold));
        return this;
    }

    public AccountUpdateTransaction setReceiveRecordThreshold(Hbar receiveRecordThreshold) {
        this.builder.setReceiveRecordThresholdWrapper(UInt64Value.of((long)receiveRecordThreshold.asTinybar()));
        return this;
    }

    public AccountUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(autoRenewPeriod));
        return this;
    }

    public AccountUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.builder.setExpirationTime(TimestampHelper.timestampFrom(expirationTime));
        return this;
    }

    public AccountUpdateTransaction setReceiverSignatureRequired(boolean receiverSignatureRequired) {
        this.builder.setReceiverSigRequiredWrapper(BoolValue.of((boolean)receiverSignatureRequired));
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasAccountIDToUpdate(), ".setAccountForUpdate() required");
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return CryptoServiceGrpc.getUpdateAccountMethod();
    }
}

