/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.AccountAmount;
import com.hedera.hashgraph.proto.AccountAmountOrBuilder;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.CryptoTransferTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.proto.TransferList;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import io.grpc.MethodDescriptor;
import javax.annotation.Nonnegative;

public final class CryptoTransferTransaction
extends TransactionBuilder<CryptoTransferTransaction> {
    private final CryptoTransferTransactionBody.Builder builder;
    private final TransferList.Builder transferList;

    public CryptoTransferTransaction() {
        this.builder = this.bodyBuilder.getCryptoTransferBuilder();
        this.transferList = this.builder.getTransfersBuilder();
    }

    public CryptoTransferTransaction addSender(AccountId senderId, Hbar value) {
        return this.addTransfer(senderId, value.asTinybar() * -1L);
    }

    public CryptoTransferTransaction addSender(AccountId senderId, @Nonnegative long value) {
        return this.addTransfer(senderId, value * -1L);
    }

    public CryptoTransferTransaction addRecipient(AccountId recipientId, Hbar value) {
        return this.addTransfer(recipientId, value.asTinybar());
    }

    public CryptoTransferTransaction addRecipient(AccountId recipientId, @Nonnegative long value) {
        return this.addTransfer(recipientId, value);
    }

    public CryptoTransferTransaction addTransfer(AccountId accountId, long value) {
        this.transferList.addAccountAmounts(AccountAmount.newBuilder().setAccountID(accountId.toProto()).setAmount(value).build());
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.transferList.getAccountAmountsOrBuilderList(), "at least one transfer required");
        long sum = 0L;
        for (AccountAmountOrBuilder accountAmountOrBuilder : this.transferList.getAccountAmountsOrBuilderList()) {
            sum += accountAmountOrBuilder.getAmount();
        }
        if (sum != 0L) {
            this.addValidationError(String.format("transfer transaction must have zero sum; transfer balance: %d tinybar", sum));
        }
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return CryptoServiceGrpc.getCryptoTransferMethod();
    }
}

