/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.ConsensusSubmitMessageTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import io.grpc.MethodDescriptor;

public class ConsensusMessageSubmitTransaction
extends TransactionBuilder<ConsensusMessageSubmitTransaction> {
    private ConsensusSubmitMessageTransactionBody.Builder builder;

    public ConsensusMessageSubmitTransaction() {
        this.builder = this.bodyBuilder.getConsensusSubmitMessageBuilder();
    }

    public ConsensusMessageSubmitTransaction setTopicId(ConsensusTopicId topicId) {
        this.builder.setTopicID(topicId.toProto());
        return this;
    }

    public ConsensusMessageSubmitTransaction setMessage(byte[] message) {
        this.builder.setMessage(ByteString.copyFrom((byte[])message));
        return this;
    }

    public ConsensusMessageSubmitTransaction setMessage(String message) {
        this.builder.setMessage(ByteString.copyFromUtf8((String)message));
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasTopicID(), "setTopicId() required");
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return ConsensusServiceGrpc.getSubmitMessageMethod();
    }
}

