/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.hedera.hashgraph.proto.ConsensusCreateTopicTransactionBody;
import com.hedera.hashgraph.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.HederaConstants;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;

public class ConsensusTopicCreateTransaction
extends TransactionBuilder<ConsensusTopicCreateTransaction> {
    private final ConsensusCreateTopicTransactionBody.Builder builder;

    public ConsensusTopicCreateTransaction() {
        this.builder = this.bodyBuilder.getConsensusCreateTopicBuilder();
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(HederaConstants.DEFAULT_AUTORENEW_DURATION));
    }

    public ConsensusTopicCreateTransaction setTopicMemo(String topicMemo) {
        this.builder.setMemo(topicMemo);
        return this;
    }

    public ConsensusTopicCreateTransaction setAdminKey(PublicKey key) {
        this.builder.setAdminKey(key.toKeyProto());
        return this;
    }

    public ConsensusTopicCreateTransaction setSubmitKey(PublicKey key) {
        this.builder.setSubmitKey(key.toKeyProto());
        return this;
    }

    public ConsensusTopicCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(autoRenewPeriod));
        return this;
    }

    public ConsensusTopicCreateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        this.builder.setAutoRenewAccount(autoRenewAccountId.toProto());
        return this;
    }

    @Override
    protected void doValidate() {
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return ConsensusServiceGrpc.getCreateTopicMethod();
    }
}

