/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.google.protobuf.StringValue;
import com.hedera.hashgraph.proto.AccountID;
import com.hedera.hashgraph.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.ConsensusUpdateTopicTransactionBody;
import com.hedera.hashgraph.proto.Key;
import com.hedera.hashgraph.proto.KeyList;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public class ConsensusTopicUpdateTransaction
extends TransactionBuilder<ConsensusTopicUpdateTransaction> {
    private final ConsensusUpdateTopicTransactionBody.Builder builder;

    public ConsensusTopicUpdateTransaction() {
        this.builder = this.bodyBuilder.getConsensusUpdateTopicBuilder();
    }

    public ConsensusTopicUpdateTransaction setTopicId(ConsensusTopicId topicId) {
        this.builder.setTopicID(topicId.toProto());
        return this;
    }

    public ConsensusTopicUpdateTransaction setTopicMemo(String topicMemo) {
        this.builder.setMemo(StringValue.of((String)topicMemo));
        return this;
    }

    public ConsensusTopicUpdateTransaction clearTopicMemo() {
        this.builder.setMemo(StringValue.of((String)""));
        return this;
    }

    public ConsensusTopicUpdateTransaction setAdminKey(PublicKey key) {
        this.builder.setAdminKey(key.toKeyProto());
        return this;
    }

    public ConsensusTopicUpdateTransaction clearAdminKey() {
        this.builder.setAdminKey(Key.newBuilder().setKeyList(KeyList.getDefaultInstance()));
        return this;
    }

    public ConsensusTopicUpdateTransaction setSubmitKey(PublicKey key) {
        this.builder.setSubmitKey(key.toKeyProto());
        return this;
    }

    public ConsensusTopicUpdateTransaction clearSubmitKey() {
        this.builder.setSubmitKey(Key.newBuilder().setKeyList(KeyList.getDefaultInstance()));
        return this;
    }

    public ConsensusTopicUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.builder.setExpirationTime(TimestampHelper.timestampFrom(expirationTime));
        return this;
    }

    public ConsensusTopicUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(autoRenewPeriod));
        return this;
    }

    public ConsensusTopicUpdateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        this.builder.setAutoRenewAccount(autoRenewAccountId.toProto());
        return this;
    }

    public ConsensusTopicUpdateTransaction clearAutoRenewAccountId() {
        this.builder.setAutoRenewAccount(AccountID.getDefaultInstance());
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasTopicID(), ".setTopicId() required");
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return ConsensusServiceGrpc.getUpdateTopicMethod();
    }
}

