/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ContractCreateTransactionBody;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaConstants;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.contract.ContractFunctionParams;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;
import java.time.Duration;

public class ContractCreateTransaction
extends TransactionBuilder<ContractCreateTransaction> {
    private final ContractCreateTransactionBody.Builder builder;

    public ContractCreateTransaction() {
        this.builder = this.bodyBuilder.getContractCreateInstanceBuilder();
        this.setAutoRenewPeriod(HederaConstants.DEFAULT_AUTORENEW_DURATION);
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return SmartContractServiceGrpc.getCreateContractMethod();
    }

    public ContractCreateTransaction setBytecodeFileId(FileId fileId) {
        this.builder.setFileID(fileId.toProto());
        return this;
    }

    public ContractCreateTransaction setAdminKey(PublicKey adminKey) {
        this.builder.setAdminKey(adminKey.toKeyProto());
        return this;
    }

    public ContractCreateTransaction setGas(long gas) {
        this.builder.setGas(gas);
        return this;
    }

    public ContractCreateTransaction setInitialBalance(Hbar intialBalance) {
        this.builder.setInitialBalance(intialBalance.asTinybar());
        return this;
    }

    public ContractCreateTransaction setInitialBalance(long intialBalance) {
        this.builder.setInitialBalance(intialBalance);
        return this;
    }

    public ContractCreateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.builder.setProxyAccountID(proxyAccountId.toProto());
        return this;
    }

    public ContractCreateTransaction setAutoRenewPeriod(Duration duration) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(duration));
        return this;
    }

    public ContractCreateTransaction setConstructorParams(byte[] constructorParams) {
        this.builder.setConstructorParameters(ByteString.copyFrom((byte[])constructorParams));
        return this;
    }

    public ContractCreateTransaction setConstructorParams(ContractFunctionParams constructorParams) {
        this.builder.setConstructorParameters(constructorParams.toBytes(null));
        return this;
    }

    public ContractCreateTransaction setContractMemo(String memo) {
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasFileID(), ".setBytecodeFile() required");
    }
}

