/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.contract.ContractFunctionSelector;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public final class ContractFunctionParams {
    public static final int ADDRESS_LEN = 20;
    public static final int ADDRESS_LEN_HEX = 40;
    public static final int SELECTOR_LEN = 4;
    public static final int SELECTOR_LEN_HEX = 8;
    private static final ByteString padding = ByteString.copyFrom((byte[])new byte[31]);
    private static final ByteString negativePadding;
    private final ArrayList<Argument> args = new ArrayList();

    public ContractFunctionParams addString(String param) {
        this.args.add(new Argument("string", ContractFunctionParams.encodeString(param), true));
        return this;
    }

    public ContractFunctionParams addStringArray(String[] strings) {
        List<ByteString> byteStrings = Arrays.stream(strings).map(ContractFunctionParams::encodeString).collect(Collectors.toList());
        ByteString argBytes = ContractFunctionParams.encodeDynArr(byteStrings);
        this.args.add(new Argument("string[]", argBytes, true));
        return this;
    }

    public ContractFunctionParams addBytes(byte[] param) {
        this.args.add(new Argument("bytes", ContractFunctionParams.encodeBytes(param), true));
        return this;
    }

    public ContractFunctionParams addBytesArray(byte[][] param) {
        List<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParams::encodeBytes).collect(Collectors.toList());
        this.args.add(new Argument("bytes[]", ContractFunctionParams.encodeDynArr(byteArrays), true));
        return this;
    }

    public ContractFunctionParams addBytes32(byte[] param) {
        this.args.add(new Argument("bytes32", ContractFunctionParams.encodeBytes32(param), false));
        return this;
    }

    public ContractFunctionParams addBytes32Array(byte[][] param) {
        List<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParams::encodeBytes32).collect(Collectors.toList());
        this.args.add(new Argument("bytes32[]", ContractFunctionParams.encodeDynArr(byteArrays), true));
        return this;
    }

    public ContractFunctionParams addBool(boolean bool) {
        this.args.add(new Argument("bool", ContractFunctionParams.int256(bool ? 1L : 0L, 8), false));
        return this;
    }

    public ContractFunctionParams addInt8(byte value) {
        this.args.add(new Argument("int8", ContractFunctionParams.int256(value, 32), false));
        return this;
    }

    public ContractFunctionParams addInt32(int value) {
        this.args.add(new Argument("int32", ContractFunctionParams.int256(value, 32), false));
        return this;
    }

    public ContractFunctionParams addInt64(long value) {
        this.args.add(new Argument("int64", ContractFunctionParams.int256(value, 64), false));
        return this;
    }

    public ContractFunctionParams addInt256(BigInteger bigInt) {
        ContractFunctionParams.checkBigInt(bigInt);
        this.args.add(new Argument("int256", ContractFunctionParams.int256(bigInt), false));
        return this;
    }

    public ContractFunctionParams addInt8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParams.int256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addInt32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParams.int256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addInt64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParams.int256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 64).concat(arrayBytes);
        this.args.add(new Argument("int64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addInt256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(ContractFunctionParams::int256).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 256).concat(arrayBytes);
        this.args.add(new Argument("int256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addUint8(byte value) {
        this.args.add(new Argument("uint8", ContractFunctionParams.uint256(value, 8), false));
        return this;
    }

    public ContractFunctionParams addUint32(int value) {
        this.args.add(new Argument("uint32", ContractFunctionParams.uint256(value, 32), false));
        return this;
    }

    public ContractFunctionParams addUint64(long value) {
        this.args.add(new Argument("uint64", ContractFunctionParams.uint256(value, 64), false));
        return this;
    }

    public ContractFunctionParams addUint256(@Nonnegative BigInteger bigUint) {
        ContractFunctionParams.checkBigUint(bigUint);
        this.args.add(new Argument("uint256", ContractFunctionParams.uint256(bigUint), false));
        return this;
    }

    public ContractFunctionParams addUint8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParams.uint256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addUint32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParams.uint256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addUint64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParams.uint256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 64).concat(arrayBytes);
        this.args.add(new Argument("uint64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addUint256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(ContractFunctionParams::uint256).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParams.uint256(intArray.length, 256).concat(arrayBytes);
        this.args.add(new Argument("uint256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParams addAddress(String address) {
        byte[] addressBytes = ContractFunctionParams.decodeAddress(address);
        this.args.add(new Argument("address", ContractFunctionParams.leftPad32(ByteString.copyFrom((byte[])addressBytes)), false));
        return this;
    }

    public ContractFunctionParams addAddressArray(String[] addresses) {
        ByteString addressArray = ContractFunctionParams.encodeArray(Arrays.stream(addresses).map(a -> {
            byte[] address = ContractFunctionParams.decodeAddress(a);
            ContractFunctionParams.checkAddressLen(address);
            return ContractFunctionParams.leftPad32(ByteString.copyFrom((byte[])address));
        }));
        this.args.add(new Argument("address[]", addressArray, true));
        return this;
    }

    public ContractFunctionParams addFunction(String address, byte[] selector) {
        return this.addFunction(ContractFunctionParams.decodeAddress(address), selector);
    }

    public ContractFunctionParams addFunction(String address, ContractFunctionSelector selector) {
        return this.addFunction(ContractFunctionParams.decodeAddress(address), selector.finish());
    }

    ByteString toBytes(@Nullable String funcName) {
        int dynamicOffset = this.args.size() * 32;
        ArrayList<Object> paramsBytes = new ArrayList<Object>(this.args.size() + 1);
        ArrayList<ByteString> dynamicArgs = new ArrayList<ByteString>();
        ContractFunctionSelector functionSelector = funcName != null ? new ContractFunctionSelector(funcName) : null;
        for (Argument arg : this.args) {
            if (functionSelector != null) {
                functionSelector.addParamType(arg.type);
            }
            if (arg.isDynamic) {
                paramsBytes.add(ContractFunctionParams.int256(dynamicOffset, 256));
                dynamicArgs.add(arg.value);
                dynamicOffset += arg.value.size();
                continue;
            }
            paramsBytes.add(arg.value);
        }
        if (functionSelector != null) {
            paramsBytes.add(0, ByteString.copyFrom((byte[])functionSelector.finish()));
        }
        paramsBytes.addAll(dynamicArgs);
        return ByteString.copyFrom(paramsBytes);
    }

    private static ByteString encodeString(String string) {
        ByteString strBytes = ByteString.copyFromUtf8((String)string);
        return ContractFunctionParams.int256(strBytes.size(), 32).concat(ContractFunctionParams.rightPad32(strBytes));
    }

    private static ByteString encodeBytes(byte[] bytes) {
        return ContractFunctionParams.int256(bytes.length, 32).concat(ContractFunctionParams.rightPad32(ByteString.copyFrom((byte[])bytes)));
    }

    private static ByteString encodeBytes32(byte[] bytes) {
        return ContractFunctionParams.rightPad32(ByteString.copyFrom((byte[])bytes, (int)0, (int)32));
    }

    private static ByteString encodeArray(Stream<ByteString> elements) {
        List list = elements.collect(Collectors.toList());
        return ContractFunctionParams.int256(list.size(), 32).concat(ByteString.copyFrom(list));
    }

    private static ByteString encodeDynArr(List<ByteString> elements) {
        int offsetsLen = elements.size() + 1;
        ArrayList<ByteString> offsets = new ArrayList<ByteString>(offsetsLen);
        offsets.add(ContractFunctionParams.uint256(elements.size(), 32));
        long currOffset = (long)offsetsLen * 32L;
        for (ByteString elem : elements) {
            offsets.add(ContractFunctionParams.uint256(currOffset, 64));
            currOffset += (long)elem.size();
        }
        return ByteString.copyFrom(offsets).concat(ByteString.copyFrom(elements));
    }

    private static void checkBigInt(BigInteger val) {
        if (val.bitLength() > 255) {
            throw new IllegalArgumentException("BigInteger out of range for Solidity integers");
        }
    }

    private static void checkBigUint(BigInteger val) {
        if (val.signum() < 0) {
            throw new IllegalArgumentException("negative BigInteger passed to unsigned function");
        }
        if (val.bitLength() > 256) {
            throw new IllegalArgumentException("BigInteger out of range for Solidity integers");
        }
    }

    static ByteString uint256(long val, int bitWidth) {
        return ContractFunctionParams.int256(val, bitWidth, false);
    }

    static ByteString int256(long val, int bitWidth) {
        return ContractFunctionParams.int256(val, bitWidth, true);
    }

    static ByteString int256(long val, int bitWidth, boolean signed) {
        bitWidth = Math.min(bitWidth, 64);
        ByteString.Output output = ByteString.newOutput((int)(bitWidth / 8));
        for (int i = bitWidth - 8; i >= 0; i -= 8) {
            byte u8 = (byte)(val >> i);
            output.write((int)u8);
        }
        return ContractFunctionParams.leftPad32(output.toByteString(), signed && val < 0L);
    }

    static ByteString uint256(BigInteger bigInt) {
        if (bigInt.bitLength() == 256) {
            return ByteString.copyFrom((byte[])bigInt.toByteArray(), (int)1, (int)32);
        }
        return ContractFunctionParams.leftPad32(bigInt.toByteArray(), false);
    }

    static ByteString int256(BigInteger bigInt) {
        return ContractFunctionParams.leftPad32(bigInt.toByteArray(), bigInt.signum() < 0);
    }

    static ByteString leftPad32(ByteString input) {
        return ContractFunctionParams.leftPad32(input, false);
    }

    static ByteString leftPad32(ByteString input, boolean negative) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : (negative ? negativePadding : padding).substring(0, rem).concat(input);
    }

    static ByteString leftPad32(byte[] input, boolean negative) {
        return ContractFunctionParams.leftPad32(ByteString.copyFrom((byte[])input), negative);
    }

    static ByteString rightPad32(ByteString input) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : input.concat(padding.substring(0, rem));
    }

    private static void checkAddressLen(byte[] address) {
        if (address.length != 20) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
    }

    private static byte[] decodeAddress(String address) {
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    private ContractFunctionParams addFunction(byte[] address, byte[] selector) {
        ContractFunctionParams.checkAddressLen(address);
        if (selector.length != 4) {
            throw new IllegalArgumentException("function selectors must be 4 bytes or 8 hex chars");
        }
        ByteString.Output output = ByteString.newOutput((int)24);
        output.write(address, 0, address.length);
        output.write(selector, 0, selector.length);
        this.args.add(new Argument("function", ContractFunctionParams.rightPad32(output.toByteString()), false));
        return this;
    }

    static {
        byte[] fill = new byte[31];
        Arrays.fill(fill, (byte)-1);
        negativePadding = ByteString.copyFrom((byte[])fill);
    }

    private static final class Argument {
        private final String type;
        private final ByteString value;
        private final boolean isDynamic;

        private Argument(String type, ByteString value, boolean isDynamic) {
            this.type = type;
            if (!isDynamic && value.size() != 32) {
                throw new IllegalArgumentException("value argument that was not 32 bytes");
            }
            this.value = value;
            this.isDynamic = isDynamic;
        }
    }
}

