/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ContractFunctionResultOrBuilder;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.contract.ContractLogInfo;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class ContractFunctionResult {
    private final ByteString rawResult;
    public final ContractId contractId;
    @Nullable
    public final String errorMessage;
    public final byte[] bloom;
    public final long gasUsed;
    public final List<ContractLogInfo> logs;
    private static final ByteString errorPrefix = ByteString.copyFrom((byte[])new byte[]{8, -61, 121, -96});

    @Internal
    public ContractFunctionResult(ContractFunctionResultOrBuilder inner) {
        this.contractId = new ContractId(inner.getContractIDOrBuilder());
        String errMsg = inner.getErrorMessage();
        this.errorMessage = !errMsg.isEmpty() ? errMsg : null;
        ByteString callResult = inner.getContractCallResult();
        this.rawResult = this.errorMessage != null && callResult.startsWith(errorPrefix) ? callResult.substring(4) : callResult;
        this.bloom = inner.getBloom().toByteArray();
        this.gasUsed = inner.getGasUsed();
        this.logs = inner.getLogInfoList().stream().map(ContractLogInfo::new).collect(Collectors.toList());
    }

    public byte[] asBytes() {
        return this.rawResult.toByteArray();
    }

    public String getString(int valIndex) {
        return this.getDynamicBytes(valIndex).toStringUtf8();
    }

    public byte[] getBytes(int valIndex) {
        return this.getDynamicBytes(valIndex).toByteArray();
    }

    public byte[] getBytes32(int valIndex) {
        return this.getByteString(valIndex * 32, (valIndex + 1) * 32).toByteArray();
    }

    private ByteString getDynamicBytes(int valIndex) {
        int offset = this.getInt32(valIndex);
        int len = this.getIntValueAt(offset);
        return this.getByteString(offset + 32, offset + 32 + len);
    }

    public boolean getBool(int valIndex) {
        return this.getInt8(valIndex) != 0;
    }

    public byte getInt8(int valIndex) {
        return this.getByteBuffer(valIndex * 32 + 31).get();
    }

    public int getInt32(int valIndex) {
        return this.getIntValueAt(valIndex * 32);
    }

    public long getInt64(int valIndex) {
        return this.getByteBuffer(valIndex * 32 + 24).getLong();
    }

    public BigInteger getInt256(int valIndex) {
        return new BigInteger(this.getBytes32(valIndex));
    }

    public byte getUint8(int valIndex) {
        return this.getInt8(valIndex);
    }

    public int getUint32(int valIndex) {
        return this.getInt32(valIndex);
    }

    public long getUint64(int valIndex) {
        return this.getInt64(valIndex);
    }

    public BigInteger getUint256(int valIndex) {
        byte[] bytes = new byte[33];
        this.getByteString(valIndex * 32, (valIndex + 1) * 32).copyTo(bytes, 1);
        return new BigInteger(bytes);
    }

    public String getAddress(int valIndex) {
        int offset = valIndex * 32;
        return Hex.toHexString((byte[])this.getByteString(offset + 12, offset + 32).toByteArray());
    }

    private int getIntValueAt(int valueOffset) {
        return this.getByteBuffer(valueOffset + 28).getInt();
    }

    private ByteBuffer getByteBuffer(int offset) {
        ByteBuffer byteBuffer = this.rawResult.asReadOnlyByteBuffer();
        byteBuffer.position(byteBuffer.position() + offset);
        return byteBuffer;
    }

    private ByteString getByteString(int startIndex, int endIndex) {
        return this.rawResult.substring(startIndex, endIndex);
    }
}

