/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto;

import com.hedera.hashgraph.sdk.crypto.MnemonicValidationStatus;
import java.util.List;
import javax.annotation.Nullable;

public final class MnemonicValidationResult {
    public final MnemonicValidationStatus status;
    @Nullable
    public final List<Integer> unknownIndices;

    MnemonicValidationResult(MnemonicValidationStatus status) {
        this(status, null);
    }

    MnemonicValidationResult(MnemonicValidationStatus status, @Nullable List<Integer> unknownIndices) {
        this.status = status;
        this.unknownIndices = unknownIndices;
    }

    public boolean isOk() {
        return this.status == MnemonicValidationStatus.Ok;
    }

    public String toString() {
        switch (this.status) {
            case Ok: {
                return "OK";
            }
            case BadLength: {
                return "mnemonic was not exactly 24 words";
            }
            case UnknownWords: {
                return "mnemonic contained words that are not in the standard BIP-39 English word list";
            }
            case ChecksumMismatch: {
                return "checksum word in mnemonic did not match the rest of the mnemonic";
            }
        }
        throw new Error("(BUG) missing branch for status: " + (Object)((Object)this.status));
    }
}

