/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto.ed25519;

import com.hedera.hashgraph.sdk.crypto.BadKeyException;
import com.hedera.hashgraph.sdk.crypto.CryptoUtils;
import com.hedera.hashgraph.sdk.crypto.Keystore;
import com.hedera.hashgraph.sdk.crypto.Mnemonic;
import com.hedera.hashgraph.sdk.crypto.PemUtils;
import com.hedera.hashgraph.sdk.crypto.PrivateKey;
import com.hedera.hashgraph.sdk.crypto.ed25519.Ed25519PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public final class Ed25519PrivateKey
extends PrivateKey<Ed25519PublicKey> {
    final Ed25519PrivateKeyParameters privKeyParams;
    @Nullable
    private final KeyParameter chainCode;

    private Ed25519PrivateKey(Ed25519PrivateKeyParameters privKeyParams) {
        super(new Ed25519PublicKey(privKeyParams.generatePublicKey()));
        this.privKeyParams = privKeyParams;
        this.chainCode = null;
    }

    private Ed25519PrivateKey(Ed25519PrivateKeyParameters privKeyParams, KeyParameter chainCode) {
        super(new Ed25519PublicKey(privKeyParams.generatePublicKey()));
        this.privKeyParams = privKeyParams;
        this.chainCode = chainCode;
    }

    private Ed25519PrivateKey(Ed25519PrivateKeyParameters privKeyParams, Ed25519PublicKeyParameters pubKeyParams) {
        super(new Ed25519PublicKey(pubKeyParams));
        this.privKeyParams = privKeyParams;
        this.chainCode = null;
    }

    private static Ed25519PrivateKey derivableKey(byte[] deriveData) {
        Ed25519PrivateKeyParameters privateKeyParameters = new Ed25519PrivateKeyParameters(deriveData, 0);
        KeyParameter chainCode = new KeyParameter(deriveData, 32, 32);
        return new Ed25519PrivateKey(privateKeyParameters, chainCode);
    }

    private static Ed25519PrivateKey fromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        Ed25519PrivateKeyParameters privKeyParams;
        Ed25519PublicKeyParameters pubKeyParams = null;
        try {
            ASN1Encodable privateKey = privateKeyInfo.parsePrivateKey();
            privKeyParams = new Ed25519PrivateKeyParameters(((ASN1OctetString)privateKey).getOctets(), 0);
            ASN1BitString pubKeyData = privateKeyInfo.getPublicKeyData();
            if (pubKeyData != null) {
                pubKeyParams = new Ed25519PublicKeyParameters(pubKeyData.getOctets(), 0);
            }
        }
        catch (IOException e) {
            throw new BadKeyException(e);
        }
        if (pubKeyParams != null) {
            return new Ed25519PrivateKey(privKeyParams, pubKeyParams);
        }
        return new Ed25519PrivateKey(privKeyParams);
    }

    public static Ed25519PrivateKey fromBytes(byte[] keyBytes) {
        if (keyBytes.length == 32) {
            return new Ed25519PrivateKey(new Ed25519PrivateKeyParameters(keyBytes, 0));
        }
        if (keyBytes.length == 64) {
            return new Ed25519PrivateKey(new Ed25519PrivateKeyParameters(keyBytes, 0), new Ed25519PublicKeyParameters(keyBytes, 32));
        }
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)keyBytes);
        return Ed25519PrivateKey.fromPrivateKeyInfo(privateKeyInfo);
    }

    public static Ed25519PrivateKey fromMnemonic(Mnemonic mnemonic, String passphrase) {
        byte[] seed = mnemonic.toSeed(passphrase);
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)new KeyParameter("ed25519 seed".getBytes(StandardCharsets.UTF_8)));
        hmacSha512.update(seed, 0, seed.length);
        byte[] derivedState = new byte[hmacSha512.getMacSize()];
        hmacSha512.doFinal(derivedState, 0);
        Ed25519PrivateKey derivedKey = Ed25519PrivateKey.derivableKey(derivedState);
        for (int index : new int[]{44, 3030, 0, 0}) {
            derivedKey = derivedKey.derive(index);
        }
        return derivedKey;
    }

    public static Ed25519PrivateKey fromMnemonic(Mnemonic mnemonic) {
        return Ed25519PrivateKey.fromMnemonic(mnemonic, "");
    }

    public boolean supportsDerivation() {
        return this.chainCode != null;
    }

    public Ed25519PrivateKey derive(int index) {
        if (this.chainCode == null) {
            throw new IllegalStateException("this private key does not support derivation");
        }
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)this.chainCode);
        hmacSha512.update((byte)0);
        hmacSha512.update(this.privKeyParams.getEncoded(), 0, 32);
        byte[] indexBytes = new byte[4];
        ByteBuffer.wrap(indexBytes).order(ByteOrder.BIG_ENDIAN).putInt(index);
        indexBytes[0] = (byte)(indexBytes[0] | 0xFFFFFF80);
        hmacSha512.update(indexBytes, 0, indexBytes.length);
        byte[] output = new byte[64];
        hmacSha512.doFinal(output, 0);
        Ed25519PrivateKeyParameters childKeyParams = new Ed25519PrivateKeyParameters(output, 0);
        KeyParameter childChainCode = new KeyParameter(output, 32, 32);
        return new Ed25519PrivateKey(childKeyParams, childChainCode);
    }

    @Deprecated
    public static Ed25519PrivateKey fromPem(Reader pemFile) throws IOException {
        return Ed25519PrivateKey.readPem(pemFile);
    }

    public static Ed25519PrivateKey readPem(Reader pemFile) throws IOException {
        return Ed25519PrivateKey.readPem(pemFile, null);
    }

    public static Ed25519PrivateKey readPem(Reader pemFile, @Nullable String password) throws IOException {
        return Ed25519PrivateKey.fromPrivateKeyInfo(PemUtils.readPrivateKey(pemFile, password));
    }

    public static Ed25519PrivateKey fromPem(String pemEncoded) throws IOException {
        return Ed25519PrivateKey.readPem(new StringReader(pemEncoded));
    }

    public static Ed25519PrivateKey fromPem(String encodedPem, @Nullable String password) throws IOException {
        return Ed25519PrivateKey.readPem(new StringReader(encodedPem), password);
    }

    public static Ed25519PrivateKey fromString(String privateKeyString) {
        byte[] keyBytes = Hex.decode((String)privateKeyString);
        return Ed25519PrivateKey.fromBytes(keyBytes);
    }

    public static Ed25519PrivateKey readKeystore(InputStream inputStream, String passphrase) throws IOException {
        return Keystore.fromStream(inputStream, passphrase).getEd25519();
    }

    public static Ed25519PrivateKey fromKeystore(byte[] bytes, String passphrase) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            return Ed25519PrivateKey.readKeystore(bis, passphrase);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Ed25519PrivateKey generate() {
        return Ed25519PrivateKey.generate(CryptoUtils.secureRandom);
    }

    public static Ed25519PrivateKey generate(SecureRandom secureRandom) {
        byte[] deriveData = new byte[64];
        secureRandom.nextBytes(deriveData);
        return Ed25519PrivateKey.derivableKey(deriveData);
    }

    @Override
    public byte[] toBytes() {
        return this.privKeyParams.getEncoded();
    }

    @Override
    public byte[] sign(byte[] message, int messageOffset, int messageLen) {
        byte[] secret = this.privKeyParams.getEncoded();
        byte[] sigBytes = new byte[64];
        Ed25519.sign((byte[])secret, (int)0, (byte[])message, (int)messageOffset, (int)messageLen, (byte[])sigBytes, (int)0);
        return sigBytes;
    }

    private byte[] encodeDER() {
        PrivateKeyInfo privateKeyInfo = this.toPrivateKeyInfo();
        try {
            return privateKeyInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKeyInfo toPrivateKeyInfo() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(this.privKeyParams.getEncoded()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Hex.toHexString((byte[])this.encodeDER());
    }

    @Deprecated
    public void writePem(Writer out) throws IOException {
        PemWriter pemWriter = new PemWriter(out);
        pemWriter.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", this.encodeDER()));
        pemWriter.flush();
    }

    public void writeKeystore(OutputStream outputStream, String passphrase) throws IOException {
        new Keystore(this).export(outputStream, passphrase);
    }

    public byte[] toKeystore(String passphrase) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.writeKeystore(bos, passphrase);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }
}

