/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.hedera.hashgraph.proto.FileGetInfoQuery;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.file.FileId;
import com.hedera.hashgraph.sdk.file.FileInfo;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public class FileInfoQuery
extends QueryBuilder<FileInfo, FileInfoQuery> {
    private final FileGetInfoQuery.Builder builder;

    public FileInfoQuery() {
        this.builder = this.inner.getFileGetInfoBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public FileInfoQuery setFileId(FileId fileId) {
        this.builder.setFileID(fileId.toProto());
        return this;
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return FileServiceGrpc.getGetFileInfoMethod();
    }

    @Override
    protected FileInfo extractResponse(Response raw) {
        return FileInfo.fromResponse(raw);
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasFileID(), ".setFileId() required");
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return Math.max(super.getCost(client), 50L);
    }

    @Override
    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        super.getCostAsync(client, cost -> withCost.accept(Math.min(cost, 25L)), onError);
    }
}

