/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.FileUpdateTransactionBody;
import com.hedera.hashgraph.proto.KeyList;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;
import java.time.Instant;

public class FileUpdateTransaction
extends TransactionBuilder<FileUpdateTransaction> {
    private final FileUpdateTransactionBody.Builder builder;
    private KeyList.Builder keyList;

    public FileUpdateTransaction() {
        this.builder = this.bodyBuilder.getFileUpdateBuilder();
        this.keyList = this.builder.getKeysBuilder();
    }

    public FileUpdateTransaction setFileId(FileId file) {
        this.builder.setFileID(file.toProto());
        return this;
    }

    public FileUpdateTransaction setExpirationTime(Instant expiration) {
        this.builder.setExpirationTime(TimestampHelper.timestampFrom(expiration));
        return this;
    }

    public FileUpdateTransaction addKey(PublicKey key) {
        this.keyList.addKeys(key.toKeyProto());
        return this;
    }

    public FileUpdateTransaction setContents(byte[] bytes) {
        this.builder.setContents(ByteString.copyFrom((byte[])bytes));
        return this;
    }

    public FileUpdateTransaction setContents(String text) {
        this.builder.setContents(ByteString.copyFromUtf8((String)text));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return FileServiceGrpc.getUpdateFileMethod();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasFileID(), ".setFileId() required");
    }
}

