/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.mirror;

import com.hedera.hashgraph.proto.mirror.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicQuery;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import com.hedera.hashgraph.sdk.mirror.MirrorClient;
import com.hedera.hashgraph.sdk.mirror.MirrorConsensusTopicResponse;
import com.hedera.hashgraph.sdk.mirror.MirrorSubscriptionHandle;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.util.function.Consumer;

public class MirrorConsensusTopicQuery {
    private ConsensusTopicQuery.Builder builder = ConsensusTopicQuery.newBuilder();

    public MirrorConsensusTopicQuery setTopicId(ConsensusTopicId topicId) {
        this.builder.setTopicID(topicId.toProto());
        return this;
    }

    public MirrorConsensusTopicQuery setStartTime(Instant startTime) {
        this.builder.setConsensusStartTime(TimestampHelper.timestampFrom(startTime));
        return this;
    }

    public MirrorConsensusTopicQuery setEndTime(Instant endTime) {
        this.builder.setConsensusEndTime(TimestampHelper.timestampFrom(endTime));
        return this;
    }

    public MirrorConsensusTopicQuery setLimit(long limit) {
        this.builder.setLimit(limit);
        return this;
    }

    public MirrorSubscriptionHandle subscribe(MirrorClient mirrorClient, final Consumer<MirrorConsensusTopicResponse> onNext, final Consumer<Throwable> onError) {
        ClientCall call = mirrorClient.channel.newCall(ConsensusServiceGrpc.getSubscribeTopicMethod(), CallOptions.DEFAULT);
        MirrorSubscriptionHandle subscriptionHandle = new MirrorSubscriptionHandle(() -> call.cancel("unsubscribed", null));
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)this.builder.build(), (StreamObserver)new StreamObserver<ConsensusTopicResponse>(){

            public void onNext(ConsensusTopicResponse consensusTopicResponse) {
                onNext.accept(new MirrorConsensusTopicResponse(consensusTopicResponse));
            }

            public void onError(Throwable throwable) {
                onError.accept(throwable);
            }

            public void onCompleted() {
            }
        });
        return subscriptionHandle;
    }
}

