/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.ThreadUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class Backoff {
    private int attempt = 0;
    private final Duration baseDelay;
    private final Instant expiration;

    Backoff(Duration baseDelay, Duration timeout) {
        this.baseDelay = baseDelay;
        this.expiration = Instant.now().plus(timeout);
    }

    private Optional<Duration> getNextDelay() {
        ++this.attempt;
        Duration nextDelay = this.baseDelay.multipliedBy(ThreadLocalRandom.current().nextLong(1L << this.attempt));
        if (Instant.now().plus(nextDelay).isBefore(this.expiration)) {
            return Optional.of(nextDelay);
        }
        return Optional.empty();
    }

    <T, E extends Exception> T tryWhile(Predicate<E> shouldRetry, FallibleProducer<T, E> producer) throws E {
        while (true) {
            try {
                return producer.tryProduce();
            }
            catch (Exception e) {
                Optional<Duration> nextDelay = this.getNextDelay();
                if (!(e instanceof RuntimeException) && shouldRetry.test(e) && nextDelay.isPresent()) {
                    ThreadUtil.sleepDuration(nextDelay.get());
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    <T, E> void asyncTryWhile(Predicate<E> shouldRetry, Consumer<Consumer<E>> onTry, Consumer<E> onError) {
        onTry.accept(e -> {
            Optional<Duration> nextDelay = this.getNextDelay();
            if (shouldRetry.test(e) && nextDelay.isPresent()) {
                ThreadUtil.schedule(() -> this.asyncTryWhile(shouldRetry, onTry, onError), nextDelay.get());
            } else {
                onError.accept(e);
            }
        });
    }

    @FunctionalInterface
    static interface FallibleProducer<T, E extends Exception> {
        public T tryProduce() throws E;
    }
}

