/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.gson.Gson;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.account.AccountBalanceQuery;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.account.AccountInfo;
import com.hedera.hashgraph.sdk.account.AccountInfoQuery;
import com.hedera.hashgraph.sdk.crypto.PrivateKey;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.crypto.TransactionSigner;
import com.hedera.hashgraph.sdk.crypto.ed25519.Ed25519PrivateKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class Client
implements AutoCloseable {
    final Random random = new Random();
    private Map<AccountId, Node> nodes;
    static final long DEFAULT_MAX_TXN_FEE = 100000000L;
    private long maxTransactionFee = 100000000L;
    private long maxQueryPayment = 100000000L;
    @Nullable
    private AccountId operatorId;
    @Nullable
    private PublicKey operatorPublicKey;
    @Nullable
    private TransactionSigner operatorSigner;

    public Client(Map<AccountId, String> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("List of nodes must not be empty");
        }
        this.nodes = nodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> new Node((AccountId)t.getKey(), (String)t.getValue())));
    }

    public static Client forMainnet() {
        HashMap<AccountId, String> nodes = new HashMap<AccountId, String>();
        nodes.put(new AccountId(3L), "35.237.200.180:50211");
        nodes.put(new AccountId(4L), "35.186.191.247:50211");
        nodes.put(new AccountId(5L), "35.192.2.25:50211");
        nodes.put(new AccountId(6L), "35.199.161.108:50211");
        nodes.put(new AccountId(7L), "35.203.82.240:50211");
        nodes.put(new AccountId(8L), "35.236.5.219:50211");
        nodes.put(new AccountId(9L), "35.197.192.225:50211");
        nodes.put(new AccountId(10L), "35.242.233.154:50211");
        nodes.put(new AccountId(11L), "35.240.118.96:50211");
        nodes.put(new AccountId(12L), "35.204.86.32:50211");
        return new Client(nodes);
    }

    public static Client forTestnet() {
        HashMap<AccountId, String> nodes = new HashMap<AccountId, String>();
        nodes.put(new AccountId(3L), "0.testnet.hedera.com:50211");
        nodes.put(new AccountId(4L), "1.testnet.hedera.com:50211");
        nodes.put(new AccountId(5L), "2.testnet.hedera.com:50211");
        nodes.put(new AccountId(6L), "3.testnet.hedera.com:50211");
        return new Client(nodes);
    }

    public static Client forPreviewnet() {
        HashMap<AccountId, String> nodes = new HashMap<AccountId, String>();
        nodes.put(new AccountId(3L), "0.previewnet.hedera.com:50211");
        nodes.put(new AccountId(4L), "1.previewnet.hedera.com:50211");
        nodes.put(new AccountId(5L), "2.previewnet.hedera.com:50211");
        nodes.put(new AccountId(6L), "3.previewnet.hedera.com:50211");
        return new Client(nodes);
    }

    public static Client fromJson(String json) {
        return Client.fromJson(new StringReader(json));
    }

    public static Client fromJson(Reader json) {
        Config config = (Config)new Gson().fromJson(json, Config.class);
        Map<AccountId, String> nodes = config.network.entrySet().stream().collect(Collectors.toMap(entry -> AccountId.fromString((String)entry.getKey()), Map.Entry::getValue));
        Client client = new Client(nodes);
        if (config.operator != null) {
            AccountId operatorAccount = AccountId.fromString(config.operator.accountId);
            Ed25519PrivateKey privateKey = Ed25519PrivateKey.fromString(config.operator.privateKey);
            client.setOperator(operatorAccount, privateKey);
        }
        return client;
    }

    public static Client fromFile(String fileName) throws FileNotFoundException {
        return Client.fromFile(new File(fileName));
    }

    public static Client fromFile(File file) throws FileNotFoundException {
        return Client.fromJson(new FileReader(file));
    }

    public Client replaceNodes(Map<AccountId, String> nodes) {
        this.nodes.replaceAll((nodeAcct, node) -> {
            String newNodeUrl = (String)nodes.get(nodeAcct);
            if (node.address.equals(newNodeUrl)) {
                return node;
            }
            node.closeChannel();
            if (newNodeUrl != null) {
                return new Node((AccountId)nodeAcct, newNodeUrl);
            }
            return null;
        });
        this.nodes.values().removeAll(Collections.singleton(null));
        for (Map.Entry<AccountId, String> node2 : nodes.entrySet()) {
            this.nodes.put(node2.getKey(), new Node(node2.getKey(), node2.getValue()));
        }
        return this;
    }

    public Client setMaxTransactionFee(Hbar maxTransactionFee) {
        return this.setMaxTransactionFee(maxTransactionFee.asTinybar());
    }

    public Client setMaxTransactionFee(@Nonnegative long maxTransactionFee) {
        if (maxTransactionFee <= 0L) {
            throw new IllegalArgumentException("maxTransactionFee must be > 0");
        }
        this.maxTransactionFee = maxTransactionFee;
        return this;
    }

    public Client setMaxQueryPayment(Hbar maxQueryPayment) {
        return this.setMaxQueryPayment(maxQueryPayment.asTinybar());
    }

    public Client setMaxQueryPayment(@Nonnegative long maxQueryPayment) {
        if (maxQueryPayment <= 0L) {
            throw new IllegalArgumentException("maxQueryPayment must be > 0");
        }
        this.maxQueryPayment = maxQueryPayment;
        return this;
    }

    public Client setOperator(AccountId operatorId, PrivateKey<? extends PublicKey> operatorKey) {
        this.operatorId = operatorId;
        this.operatorPublicKey = operatorKey.publicKey;
        this.operatorSigner = operatorKey::sign;
        return this;
    }

    public Client setOperatorWith(AccountId accountId, PublicKey publicKey, TransactionSigner signer) {
        this.operatorId = accountId;
        this.operatorPublicKey = publicKey;
        this.operatorSigner = signer;
        return this;
    }

    public long getMaxTransactionFee() {
        return this.maxTransactionFee;
    }

    public long getMaxQueryPayment() {
        return this.maxQueryPayment;
    }

    @Nullable
    public AccountId getOperatorId() {
        return this.operatorId;
    }

    @Nullable
    PublicKey getOperatorPublicKey() {
        return this.operatorPublicKey;
    }

    @Nullable
    TransactionSigner getOperatorSigner() {
        return this.operatorSigner;
    }

    Node pickNode() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("List of channels has become empty");
        }
        int r = this.random.nextInt(this.nodes.size());
        Iterator<Node> channelIter = this.nodes.values().iterator();
        for (int i = 0; i < r; ++i) {
            channelIter.next();
        }
        return channelIter.next();
    }

    Node getNodeForId(AccountId node) {
        Node selectedChannel = this.nodes.get(node);
        if (selectedChannel == null) {
            throw new IllegalArgumentException("Node Id does not exist");
        }
        return selectedChannel;
    }

    @Deprecated
    public AccountInfo getAccount(AccountId id) throws HederaStatusException, HederaNetworkException {
        return (AccountInfo)new AccountInfoQuery().setAccountId(id).execute(this);
    }

    @Deprecated
    public void getAccountAsync(AccountId id, Consumer<AccountInfo> onSuccess, Consumer<HederaThrowable> onError) {
        new AccountInfoQuery().setAccountId(id).executeAsync(this, onSuccess, onError);
    }

    @Deprecated
    public Hbar getAccountBalance(AccountId id) throws HederaStatusException, HederaNetworkException {
        return (Hbar)new AccountBalanceQuery().setAccountId(id).execute(this);
    }

    @Deprecated
    public void getAccountBalanceAsync(AccountId id, Consumer<Hbar> onSuccess, Consumer<HederaThrowable> onError) {
        new AccountBalanceQuery().setAccountId(id).executeAsync(this, onSuccess, onError);
    }

    @Override
    public void close() throws InterruptedException, TimeoutException {
        this.close(10L, TimeUnit.SECONDS);
    }

    public void close(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long startMs = System.currentTimeMillis();
        long timeoutAtMs = startMs + timeUnit.toMillis(timeout);
        for (Node node : this.nodes.values()) {
            node.closeChannel();
        }
        for (Node node : this.nodes.values()) {
            if (timeoutAtMs <= System.currentTimeMillis()) {
                throw new TimeoutException("Hedera Client timed out waiting for all node channels to shutdown");
            }
            long nextTimeoutMs = timeoutAtMs - System.currentTimeMillis();
            node.awaitChannelTermination(nextTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private static class Config {
        private HashMap<String, String> network;
        @Nullable
        private Operator operator;

        private Config() {
        }

        private static class Operator {
            private String accountId;
            private String privateKey;

            private Operator() {
            }
        }
    }
}

