/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.Backoff;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Status;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class HederaCall<Req, RawResp, Resp, T extends HederaCall<Req, RawResp, Resp, T>> {
    @Nullable
    private List<String> validationErrors;
    private static final Duration RETRY_DELAY = Duration.ofMillis(500L);

    protected abstract MethodDescriptor<Req, RawResp> getMethod();

    @Internal
    public abstract Req toProto();

    protected abstract Channel getChannel(Client var1);

    protected abstract Resp mapResponse(RawResp var1) throws HederaStatusException;

    protected Duration getDefaultTimeout() {
        return Duration.ZERO;
    }

    protected boolean shouldRetry(HederaThrowable e) {
        if (e instanceof HederaStatusException) {
            return ((HederaStatusException)e).status == Status.Busy;
        }
        if (e instanceof HederaNetworkException) {
            io.grpc.Status status = ((HederaNetworkException)e).cause.getStatus();
            return status == io.grpc.Status.UNAVAILABLE || status == io.grpc.Status.RESOURCE_EXHAUSTED;
        }
        return false;
    }

    public Resp execute(Client client) throws HederaStatusException, HederaNetworkException {
        return this.execute(client, this.getDefaultTimeout());
    }

    public Resp execute(Client client, Duration retryTimeout) throws HederaStatusException, HederaNetworkException, LocalValidationException {
        this.localValidate();
        Backoff.FallibleProducer tryProduce = () -> {
            try {
                return this.mapResponse(ClientCalls.blockingUnaryCall((ClientCall)this.getChannel(client).newCall(this.getMethod(), CallOptions.DEFAULT), this.toProto()));
            }
            catch (StatusRuntimeException e) {
                throw new HederaNetworkException(e);
            }
        };
        return (Resp)new Backoff(RETRY_DELAY, retryTimeout).tryWhile(this::shouldRetry, tryProduce);
    }

    public final void executeAsync(Client client, Consumer<Resp> onSuccess, Consumer<HederaThrowable> onError) {
        this.executeAsync(client, this.getDefaultTimeout(), onSuccess, onError);
    }

    public void executeAsync(Client client, Duration retryTimeout, Consumer<Resp> onSuccess, Consumer<HederaThrowable> onError) {
        this.localValidate();
        Consumer executeCall = onError2 -> ClientCalls.asyncUnaryCall((ClientCall)this.getChannel(client).newCall(this.getMethod(), CallOptions.DEFAULT), this.toProto(), (StreamObserver)new CallStreamObserver(onSuccess, (Consumer)onError2));
        new Backoff(RETRY_DELAY, retryTimeout).asyncTryWhile(this::shouldRetry, executeCall, onError);
    }

    @VisibleForTesting
    public final void validate() throws LocalValidationException {
        this.localValidate();
    }

    protected abstract void localValidate() throws LocalValidationException;

    protected void addValidationError(String errMsg) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<String>();
        }
        this.validationErrors.add(errMsg);
    }

    protected void checkValidationErrors(String prologue) {
        if (this.validationErrors == null) {
            return;
        }
        List<String> errors = this.validationErrors;
        this.validationErrors = null;
        throw new LocalValidationException(prologue + ":\n" + String.join((CharSequence)"\n", errors));
    }

    protected final void require(boolean mustBeTrue, String errMsg) {
        if (!mustBeTrue) {
            this.addValidationError(errMsg);
        }
    }

    protected void require(@Nullable List<?> setValue, String errMsg) {
        this.require(setValue != null && !setValue.isEmpty(), errMsg);
    }

    protected void require(@Nullable ByteString setValue, String errMsg) {
        this.require(setValue != null && !setValue.isEmpty(), errMsg);
    }

    protected void requireExactlyOne(String errMsg, String errCollision, boolean ... values) {
        boolean oneIsTrue = false;
        for (boolean maybeTrue : values) {
            if (maybeTrue && oneIsTrue) {
                this.addValidationError(errCollision);
                return;
            }
            oneIsTrue |= maybeTrue;
        }
        if (!oneIsTrue) {
            this.addValidationError(errMsg);
        }
    }

    protected void require(@Nullable String setValue, String errMsg) {
        this.require(setValue != null && !setValue.isEmpty(), errMsg);
    }

    private final class CallStreamObserver
    implements StreamObserver<RawResp> {
        private final Consumer<Resp> onSuccess;
        private final Consumer<HederaThrowable> onError;
        private volatile boolean onNextCalled = false;

        private CallStreamObserver(Consumer<Resp> onSuccess, Consumer<HederaThrowable> onError) {
            this.onSuccess = onSuccess;
            this.onError = onError;
        }

        public void onNext(RawResp value) {
            if (this.onNextCalled) {
                return;
            }
            this.onNextCalled = true;
            try {
                Object response = HederaCall.this.mapResponse(value);
                this.onSuccess.accept(response);
            }
            catch (HederaStatusException e) {
                this.onError.accept(e);
            }
        }

        public void onError(Throwable t) {
            HederaThrowable exception;
            if (t instanceof StatusRuntimeException) {
                exception = new HederaNetworkException((StatusRuntimeException)t);
            } else if (t instanceof HederaThrowable) {
                exception = (HederaThrowable)((Object)t);
            } else {
                throw new RuntimeException("unhandled exception type", t);
            }
            this.onError.accept(exception);
        }

        public void onCompleted() {
        }
    }
}

