/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaPrecheckStatusException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.TransactionId;
import java.time.Duration;
import java.util.function.Consumer;
import javax.annotation.Nullable;

@Internal
public abstract class SingleTransactionBuilder<T extends SingleTransactionBuilder<T>>
extends TransactionBuilder<TransactionId, Transaction, T> {
    @Override
    public Transaction build(@Nullable Client client) throws LocalValidationException {
        if (client != null && this.bodyBuilder.getTransactionFee() == 0L) {
            this.setMaxTransactionFee(client.getMaxTransactionFee());
        }
        if (!this.bodyBuilder.hasNodeAccountID()) {
            Node channel;
            Node node = channel = client != null ? client.pickNode() : null;
            if (channel != null) {
                this.bodyBuilder.setNodeAccountID(channel.accountId.toProto());
            }
        }
        if (!this.bodyBuilder.hasTransactionID() && client != null && client.getOperatorId() != null) {
            this.bodyBuilder.setTransactionID(new TransactionId(client.getOperatorId()).toProto());
        }
        this.localValidate();
        this.inner.setBodyBytes(this.bodyBuilder.build().toByteString());
        return new Transaction(this.inner, this.bodyBuilder, this.getMethod());
    }

    @Override
    public TransactionId execute(Client client, Duration retryTimeout) throws HederaStatusException, HederaNetworkException {
        return this.build(client).execute(client, retryTimeout);
    }

    @Override
    public void executeAsync(Client client, Duration retryTimeout, Consumer<TransactionId> onSuccess, Consumer<HederaThrowable> onError) {
        this.build(client).executeAsync(client, retryTimeout, onSuccess, onError);
    }

    @Override
    public final com.hedera.hashgraph.proto.Transaction toProto() {
        return this.build(null).toProto();
    }

    @Internal
    public final com.hedera.hashgraph.proto.Transaction toProto(boolean requireSignature) {
        return this.build(null).toProto(requireSignature);
    }

    @Override
    protected TransactionId mapResponse(TransactionResponse response) throws HederaStatusException {
        TransactionId transactionId = new TransactionId(this.bodyBuilder.getTransactionIDOrBuilder());
        HederaPrecheckStatusException.throwIfExceptional(response.getNodeTransactionPrecheckCode(), transactionId);
        return transactionId;
    }
}

