/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.file.FileId;
import com.hedera.hashgraph.sdk.token.TokenId;

public final class TransactionReceipt {
    public final Status status;
    private final com.hedera.hashgraph.proto.TransactionReceipt inner;

    TransactionReceipt(Response response) {
        if (!response.hasTransactionGetReceipt()) {
            throw new IllegalArgumentException("response was not `TransactionGetReceipt`");
        }
        this.inner = response.getTransactionGetReceipt().getReceipt();
        this.status = Status.valueOf(this.inner.getStatus());
    }

    TransactionReceipt(com.hedera.hashgraph.proto.TransactionReceipt inner) {
        this.inner = inner;
        this.status = Status.valueOf(inner.getStatus());
    }

    public AccountId getAccountId() {
        if (!this.inner.hasAccountID()) {
            throw new IllegalStateException("receipt does not contain an account ID");
        }
        return new AccountId(this.inner.getAccountIDOrBuilder());
    }

    public FileId getFileId() {
        if (!this.inner.hasFileID()) {
            throw new IllegalStateException("receipt does not contain a file ID");
        }
        return new FileId(this.inner.getFileIDOrBuilder());
    }

    public ContractId getContractId() {
        if (!this.inner.hasContractID()) {
            throw new IllegalStateException("receipt does not contain a contract ID");
        }
        return new ContractId(this.inner.getContractIDOrBuilder());
    }

    public ConsensusTopicId getConsensusTopicId() {
        if (!this.inner.hasTopicID()) {
            throw new IllegalStateException("receipt does not contain a topic ID");
        }
        return new ConsensusTopicId(this.inner.getTopicIDOrBuilder());
    }

    public TokenId getTokenId() {
        if (!this.inner.hasTokenId()) {
            throw new IllegalStateException("receipt does not contain a token ID");
        }
        return new TokenId(this.inner.getTokenIdOrBuilder());
    }

    public long getConsensusTopicSequenceNumber() {
        return this.inner.getTopicSequenceNumber();
    }

    public byte[] getConsensusTopicRunningHash() {
        return this.inner.getTopicRunningHash().toByteArray();
    }

    @Internal
    public com.hedera.hashgraph.proto.TransactionReceipt toProto() {
        return this.inner;
    }
}

