/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.Transfer;
import com.hedera.hashgraph.sdk.contract.ContractFunctionResult;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TransactionRecord {
    public final TransactionId transactionId;
    public final byte[] transactionHash;
    public final long transactionFee;
    @Nullable
    public final Instant consensusTimestamp;
    @Nullable
    public final String transactionMemo;
    public final TransactionReceipt receipt;
    public final List<Transfer> transfers;
    private final com.hedera.hashgraph.proto.TransactionRecord inner;

    @Internal
    public TransactionRecord(com.hedera.hashgraph.proto.TransactionRecord inner) {
        this.inner = inner;
        this.transactionId = new TransactionId(inner.getTransactionIDOrBuilder());
        this.transactionFee = inner.getTransactionFee();
        this.receipt = new TransactionReceipt(inner.getReceipt());
        this.transactionHash = inner.getTransactionHash().toByteArray();
        this.consensusTimestamp = inner.hasConsensusTimestamp() ? TimestampHelper.timestampTo(inner.getConsensusTimestamp()) : null;
        String memo = inner.getMemo();
        this.transactionMemo = memo.isEmpty() ? null : memo;
        this.transfers = inner.hasTransferList() ? inner.getTransferList().getAccountAmountsList().stream().map(Transfer::new).collect(Collectors.toList()) : Collections.emptyList();
    }

    public ContractFunctionResult getContractExecuteResult() {
        if (!this.inner.hasContractCallResult()) {
            throw new IllegalStateException("record does not contain a contract execute result");
        }
        return new ContractFunctionResult(this.inner.getContractCallResultOrBuilder());
    }

    public ContractFunctionResult getContractCreateResult() {
        if (!this.inner.hasContractCreateResult()) {
            throw new IllegalStateException("record does not contain a contract create result");
        }
        return new ContractFunctionResult(this.inner.getContractCreateResultOrBuilder());
    }
}

