/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoGetAccountBalanceQuery;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.contract.ContractId;
import io.grpc.MethodDescriptor;

public final class AccountBalanceQuery
extends QueryBuilder<Hbar, AccountBalanceQuery> {
    private final CryptoGetAccountBalanceQuery.Builder builder;

    public AccountBalanceQuery() {
        this.builder = this.inner.getCryptogetAccountBalanceBuilder();
        this.setQueryPayment(0L);
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public AccountBalanceQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProto());
        return this;
    }

    public AccountBalanceQuery setContractId(ContractId contractId) {
        this.builder.setContractID(contractId.toProto());
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasAccountID() || this.builder.hasContractID(), ".setAccountId() or .setContractId() required");
        this.require(this.getHeaderBuilder().hasPayment(), "AccountBalanceQuery requires a payment for validation but it is not processed; one would have been created automatically but the given Client did not have an operator ID or key set. You must instead manually create, sign and then set a payment transaction with .setPayment().");
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getCryptoGetBalanceMethod();
    }

    @Override
    protected Hbar extractResponse(Response raw) {
        return Hbar.fromTinybar(raw.getCryptogetAccountBalance().getBalance());
    }
}

