/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoGetAccountBalanceQuery;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TokenBalance;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.token.TokenId;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.Map;

public final class TokenBalanceQuery
extends QueryBuilder<Map<TokenId, Long>, TokenBalanceQuery> {
    private final CryptoGetAccountBalanceQuery.Builder builder;

    public TokenBalanceQuery() {
        this.builder = this.inner.getCryptogetAccountBalanceBuilder();
        this.setQueryPayment(0L);
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public TokenBalanceQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProto());
        return this;
    }

    @Override
    protected void doValidate() {
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getCryptoGetBalanceMethod();
    }

    @Override
    protected Map<TokenId, Long> extractResponse(Response raw) {
        HashMap<TokenId, Long> map = new HashMap<TokenId, Long>(raw.getCryptogetAccountBalance().getTokenBalancesCount());
        for (TokenBalance balance : raw.getCryptogetAccountBalance().getTokenBalancesList()) {
            map.put(new TokenId(balance.getTokenId()), balance.getBalance());
        }
        return map;
    }
}

