/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.hedera.hashgraph.proto.TopicID;
import com.hedera.hashgraph.proto.TopicIDOrBuilder;
import com.hedera.hashgraph.sdk.IdUtil;
import com.hedera.hashgraph.sdk.Internal;
import java.util.Objects;

public final class ConsensusTopicId {
    public final long shard;
    public final long realm;
    public final long topic;

    public ConsensusTopicId(long shard, long realm, long topic) {
        this.shard = shard;
        this.realm = realm;
        this.topic = topic;
    }

    public ConsensusTopicId(long topic) {
        this(0L, 0L, topic);
    }

    @Internal
    public ConsensusTopicId(TopicIDOrBuilder topicID) {
        this(topicID.getShardNum(), topicID.getRealmNum(), topicID.getTopicNum());
    }

    public static ConsensusTopicId fromString(String topic) throws IllegalArgumentException {
        return IdUtil.parseIdString(topic, ConsensusTopicId::new);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.topic);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConsensusTopicId)) {
            return false;
        }
        ConsensusTopicId otherId = (ConsensusTopicId)other;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.topic == otherId.topic;
    }

    @Internal
    public TopicID toProto() {
        return TopicID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTopicNum(this.topic).build();
    }

    public String toString() {
        return "" + this.shard + "." + this.realm + "." + this.topic;
    }
}

