/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.hedera.hashgraph.proto.ConsensusGetTopicInfoResponse;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public class ConsensusTopicInfo {
    public final ConsensusTopicId id;
    @Nullable
    public final String topicMemo;
    public final long sequenceNumber;
    public final byte[] runningHash;
    @Nullable
    public final Instant expirationTime;
    @Nullable
    public final PublicKey adminKey;
    @Nullable
    public final PublicKey submitKey;
    public final Duration autoRenewPeriod;
    @Nullable
    public final AccountId autoRenewAccountId;

    public ConsensusTopicInfo(ConsensusGetTopicInfoResponse response) {
        this.id = new ConsensusTopicId(response.getTopicIDOrBuilder());
        com.hedera.hashgraph.proto.ConsensusTopicInfo info = response.getTopicInfo();
        this.sequenceNumber = info.getSequenceNumber();
        this.runningHash = info.getRunningHash().toByteArray();
        this.expirationTime = info.hasExpirationTime() ? TimestampHelper.timestampTo(info.getExpirationTime()) : null;
        this.adminKey = info.hasAdminKey() ? PublicKey.fromProtoKey(info.getAdminKey()) : null;
        this.submitKey = info.hasSubmitKey() ? PublicKey.fromProtoKey(info.getSubmitKey()) : null;
        String memo = info.getMemo();
        this.topicMemo = memo.isEmpty() ? null : memo;
        this.autoRenewPeriod = DurationHelper.durationTo(info.getAutoRenewPeriod());
        this.autoRenewAccountId = info.hasAutoRenewAccount() ? new AccountId(info.getAutoRenewAccount()) : null;
    }

    static ConsensusTopicInfo fromResponse(Response response) {
        if (!response.hasConsensusGetTopicInfo()) {
            throw new IllegalArgumentException("response was not `consensusGetTopicInfo`");
        }
        return new ConsensusTopicInfo(response.getConsensusGetTopicInfo());
    }

    public String toString() {
        return "topic ID: " + this.id + " sequence number: " + this.sequenceNumber + " running hash: " + Hex.toHexString((byte[])this.runningHash) + " expiration time: " + this.expirationTime + " admin key: " + this.adminKey + " submit key: " + this.submitKey + " auto-renew period: " + this.autoRenewPeriod + " auto-renew account: " + this.autoRenewAccountId + " memo: " + this.topicMemo;
    }
}

