/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ContractCallTransactionBody;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.contract.ContractFunctionParams;
import com.hedera.hashgraph.sdk.contract.ContractId;
import io.grpc.MethodDescriptor;

public final class ContractExecuteTransaction
extends SingleTransactionBuilder<ContractExecuteTransaction> {
    private final ContractCallTransactionBody.Builder builder;

    public ContractExecuteTransaction() {
        this.builder = this.bodyBuilder.getContractCallBuilder();
    }

    public ContractExecuteTransaction setContractId(ContractId contractId) {
        this.builder.setContractID(contractId.toProto());
        return this;
    }

    public ContractExecuteTransaction setGas(long gas) {
        this.builder.setGas(gas);
        return this;
    }

    public ContractExecuteTransaction setPayableAmount(Hbar amount) {
        this.builder.setAmount(amount.asTinybar());
        return this;
    }

    public ContractExecuteTransaction setPayableAmount(long amount) {
        this.builder.setAmount(amount);
        return this;
    }

    public ContractExecuteTransaction setFunctionParams(byte[] parameters) {
        this.builder.setFunctionParameters(ByteString.copyFrom((byte[])parameters));
        return this;
    }

    public ContractExecuteTransaction setFunction(String funcName) {
        return this.setFunction(funcName, new ContractFunctionParams());
    }

    public ContractExecuteTransaction setFunction(String funcName, ContractFunctionParams params) {
        this.builder.setFunctionParameters(params.toBytes(funcName));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return SmartContractServiceGrpc.getContractCallMethodMethod();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasContractID(), ".setContractId() required");
    }
}

