/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.hedera.hashgraph.proto.ContractGetInfoQuery;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.contract.ContractInfo;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public final class ContractInfoQuery
extends QueryBuilder<ContractInfo, ContractInfoQuery> {
    private final ContractGetInfoQuery.Builder builder;

    public ContractInfoQuery() {
        this.builder = this.inner.getContractGetInfoBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public ContractInfoQuery setContractId(ContractId contract) {
        this.builder.setContractID(contract.toProto());
        return this;
    }

    @Override
    public MethodDescriptor<Query, Response> getMethod() {
        return SmartContractServiceGrpc.getGetContractInfoMethod();
    }

    @Override
    protected ContractInfo extractResponse(Response raw) {
        return ContractInfo.fromResponse(raw);
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasContractID(), ".setContractId() required");
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return Math.max(super.getCost(client), 25L);
    }

    @Override
    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        super.getCostAsync(client, cost -> withCost.accept(Math.min(cost, 25L)), onError);
    }
}

