/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.FileCreateTransactionBody;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.KeyList;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public final class FileCreateTransaction
extends SingleTransactionBuilder<FileCreateTransaction> {
    private final FileCreateTransactionBody.Builder builder;
    private final KeyList.Builder keyList;

    public FileCreateTransaction() {
        this.builder = this.bodyBuilder.getFileCreateBuilder();
        this.keyList = this.builder.getKeysBuilder();
        this.setExpirationTime(Instant.now().plus(Duration.ofMillis(7890000000L)));
    }

    public FileCreateTransaction setExpirationTime(Instant expiration) {
        this.builder.setExpirationTime(TimestampHelper.timestampFrom(expiration));
        return this;
    }

    public FileCreateTransaction addKey(PublicKey key) {
        this.keyList.addKeys(key.toKeyProto());
        return this;
    }

    public FileCreateTransaction setContents(byte[] bytes) {
        this.builder.setContents(ByteString.copyFrom((byte[])bytes));
        return this;
    }

    public FileCreateTransaction setContents(String text) {
        this.builder.setContents(ByteString.copyFromUtf8((String)text));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return FileServiceGrpc.getCreateFileMethod();
    }

    @Override
    protected void doValidate() {
        this.require(!this.keyList.getKeysOrBuilderList().isEmpty(), "network currently requires files to have at least one key");
    }
}

