/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.hedera.hashgraph.proto.FileGetInfoResponse;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.file.FileId;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public final class FileInfo {
    public final FileId fileId;
    public final long size;
    public final Instant expirationTime;
    public final boolean isDeleted;
    public final List<PublicKey> keys;

    FileInfo(FileGetInfoResponse.FileInfoOrBuilder info) {
        if (!info.hasKeys() || info.getKeys().getKeysList().isEmpty()) {
            throw new IllegalArgumentException("`FileGetInfoResponse` missing keys");
        }
        this.fileId = new FileId(info.getFileIDOrBuilder());
        this.size = info.getSize();
        this.expirationTime = TimestampHelper.timestampTo(info.getExpirationTime());
        this.isDeleted = info.getDeleted();
        this.keys = info.getKeys().getKeysList().stream().map(PublicKey::fromProtoKey).collect(Collectors.toList());
    }

    static FileInfo fromResponse(Response response) {
        if (!response.hasFileGetInfo()) {
            throw new IllegalArgumentException("response was not `fileGetInfo`");
        }
        return new FileInfo(response.getFileGetInfo().getFileInfoOrBuilder());
    }
}

