/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.mirror;

import com.hedera.hashgraph.proto.TransactionID;
import com.hedera.hashgraph.proto.mirror.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicQuery;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import com.hedera.hashgraph.sdk.mirror.MirrorClient;
import com.hedera.hashgraph.sdk.mirror.MirrorConsensusTopicResponse;
import com.hedera.hashgraph.sdk.mirror.MirrorSubscriptionHandle;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MirrorConsensusTopicQuery {
    private ConsensusTopicQuery.Builder builder = ConsensusTopicQuery.newBuilder();

    public MirrorConsensusTopicQuery setTopicId(ConsensusTopicId topicId) {
        this.builder.setTopicID(topicId.toProto());
        return this;
    }

    public MirrorConsensusTopicQuery setStartTime(Instant startTime) {
        this.builder.setConsensusStartTime(TimestampHelper.timestampFrom(startTime));
        return this;
    }

    public MirrorConsensusTopicQuery setEndTime(Instant endTime) {
        this.builder.setConsensusEndTime(TimestampHelper.timestampFrom(endTime));
        return this;
    }

    public MirrorConsensusTopicQuery setLimit(long limit) {
        this.builder.setLimit(limit);
        return this;
    }

    public MirrorSubscriptionHandle subscribe(MirrorClient mirrorClient, Consumer<MirrorConsensusTopicResponse> onNext, Consumer<Throwable> onError) {
        ClientCall call = mirrorClient.channel.newCall(ConsensusServiceGrpc.getSubscribeTopicMethod(), CallOptions.DEFAULT);
        MirrorSubscriptionHandle subscriptionHandle = new MirrorSubscriptionHandle(() -> call.cancel("unsubscribed", null));
        MirrorConsensusTopicQuery.makeStreamingCall((ClientCall<ConsensusTopicQuery, ConsensusTopicResponse>)call, this.builder.build(), onNext, onError, 0);
        return subscriptionHandle;
    }

    private static void makeStreamingCall(final ClientCall<ConsensusTopicQuery, ConsensusTopicResponse> call, final ConsensusTopicQuery query, final Consumer<MirrorConsensusTopicResponse> onNext, final Consumer<Throwable> onError, final int attempt) {
        if (attempt > 10) {
            onError.accept(new Error("Failed to connect to mirror node"));
        }
        final HashMap pendingMessages = new HashMap();
        final Instant[] lastInstantChecked = new Instant[]{null};
        ClientCalls.asyncServerStreamingCall(call, (Object)query, (StreamObserver)new StreamObserver<ConsensusTopicResponse>(){
            private boolean shouldRetry = true;

            public void onNext(ConsensusTopicResponse consensusTopicResponse) {
                this.shouldRetry = false;
                if (!consensusTopicResponse.hasChunkInfo()) {
                    onNext.accept(MirrorConsensusTopicResponse.ofSingle(consensusTopicResponse));
                    return;
                }
                TransactionID initialTransactionID = consensusTopicResponse.getChunkInfo().getInitialTransactionID();
                pendingMessages.putIfAbsent(initialTransactionID, new Tuple(Instant.now(), new ArrayList()));
                ArrayList chunks = (ArrayList)((Tuple)pendingMessages.get((Object)initialTransactionID)).second;
                Objects.requireNonNull(chunks).add(consensusTopicResponse);
                if (chunks.size() == consensusTopicResponse.getChunkInfo().getTotal()) {
                    pendingMessages.remove(initialTransactionID);
                    onNext.accept(MirrorConsensusTopicResponse.ofMany(chunks));
                }
                ArrayList toRemoveTransactions = new ArrayList();
                Instant now = Instant.now();
                if (lastInstantChecked[0] == null || Duration.between(lastInstantChecked[0], now).compareTo(Duration.ofSeconds(10L)) > 0) {
                    lastInstantChecked[0] = now;
                    for (Map.Entry entry : pendingMessages.entrySet()) {
                        if (Duration.between((Temporal)((Tuple)entry.getValue()).first, now).compareTo(Duration.ofMinutes(5L)) <= 0) continue;
                        toRemoveTransactions.add(entry.getKey());
                    }
                }
                for (TransactionID id : toRemoveTransactions) {
                    pendingMessages.remove(id);
                }
            }

            public void onError(Throwable throwable) {
                StatusException status;
                if (this.shouldRetry && throwable instanceof StatusException && ((status = (StatusException)throwable).getStatus().equals((Object)Status.NOT_FOUND) || status.getStatus().equals((Object)Status.UNAVAILABLE))) {
                    try {
                        long delay = Math.min(250L * (long)Math.pow(2.0, attempt), 16000L);
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MirrorConsensusTopicQuery.makeStreamingCall((ClientCall<ConsensusTopicQuery, ConsensusTopicResponse>)call, query, onNext, onError, attempt + 1);
                }
                onError.accept(throwable);
            }

            public void onCompleted() {
            }
        });
    }

    static class Tuple<T1, T2> {
        T1 first;
        T2 second;

        Tuple(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }
}

