/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.mirror;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.mirror.MirrorConsensusMessageChunk;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public class MirrorConsensusTopicResponse {
    public final Instant consensusTimestamp;
    public final byte[] message;
    public final byte[] runningHash;
    public final long sequenceNumber;
    public final MirrorConsensusMessageChunk[] chunks;

    MirrorConsensusTopicResponse(Instant lastConsensusTimestamp, byte[] message, byte[] lastRunningHash, long lastSequenceNumber, MirrorConsensusMessageChunk[] chunks) {
        this.consensusTimestamp = lastConsensusTimestamp;
        this.message = message;
        this.runningHash = lastRunningHash;
        this.sequenceNumber = lastSequenceNumber;
        this.chunks = chunks;
    }

    static MirrorConsensusTopicResponse ofSingle(ConsensusTopicResponse response) {
        return new MirrorConsensusTopicResponse(TimestampHelper.timestampTo(response.getConsensusTimestamp()), response.getMessage().toByteArray(), response.getRunningHash().toByteArray(), response.getSequenceNumber(), new MirrorConsensusMessageChunk[]{new MirrorConsensusMessageChunk(response)});
    }

    static MirrorConsensusTopicResponse ofMany(List<ConsensusTopicResponse> responses) {
        MirrorConsensusMessageChunk[] chunks = new MirrorConsensusMessageChunk[responses.size()];
        ByteString[] contents = new ByteString[responses.size()];
        long totalSize = 0L;
        for (ConsensusTopicResponse consensusTopicResponse : responses) {
            int index = consensusTopicResponse.getChunkInfo().getNumber() - 1;
            chunks[index] = new MirrorConsensusMessageChunk(consensusTopicResponse);
            contents[index] = consensusTopicResponse.getMessage();
            totalSize += (long)consensusTopicResponse.getMessage().size();
        }
        ByteBuffer wholeMessage = ByteBuffer.allocate((int)totalSize);
        for (ByteString content : contents) {
            wholeMessage.put(content.asReadOnlyByteBuffer());
        }
        ConsensusTopicResponse consensusTopicResponse = responses.get(responses.size() - 1);
        return new MirrorConsensusTopicResponse(TimestampHelper.timestampTo(consensusTopicResponse.getConsensusTimestamp()), wholeMessage.array(), consensusTopicResponse.getRunningHash().toByteArray(), consensusTopicResponse.getSequenceNumber(), chunks);
    }

    public String toString() {
        return "ConsensusMessage{consensusTimestamp=" + this.consensusTimestamp + ", message=" + Arrays.toString(this.message) + ", runningHash=" + Arrays.toString(this.runningHash) + ", sequenceNumber=" + this.sequenceNumber + '}';
    }
}

