/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.token;

import com.hedera.hashgraph.proto.TokenCreateTransactionBody;
import com.hedera.hashgraph.proto.TokenServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.HederaConstants;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public final class TokenCreateTransaction
extends SingleTransactionBuilder<TokenCreateTransaction> {
    private final TokenCreateTransactionBody.Builder builder;

    public TokenCreateTransaction() {
        this.builder = this.bodyBuilder.getTokenCreationBuilder().setAutoRenewPeriod(HederaConstants.DEFAULT_AUTORENEW_DURATION.getSeconds()).setExpiry(Instant.now().plus(Duration.ofDays(90L)).getEpochSecond());
    }

    public TokenCreateTransaction setName(String name) {
        this.builder.setName(name);
        return this;
    }

    public TokenCreateTransaction setSymbol(String symbol) {
        this.builder.setSymbol(symbol);
        return this;
    }

    public TokenCreateTransaction setDecimals(int decimal) {
        this.builder.setDecimals(decimal);
        return this;
    }

    public TokenCreateTransaction setInitialSupply(int initialSupply) {
        this.builder.setInitialSupply(initialSupply);
        return this;
    }

    public TokenCreateTransaction setTreasury(AccountId treasury) {
        this.builder.setTreasury(treasury.toProto());
        return this;
    }

    public TokenCreateTransaction setAdminKey(PublicKey key) {
        this.builder.setAdminKey(key.toKeyProto());
        return this;
    }

    public TokenCreateTransaction setKycKey(PublicKey key) {
        this.builder.setKycKey(key.toKeyProto());
        return this;
    }

    public TokenCreateTransaction setFreezeKey(PublicKey key) {
        this.builder.setFreezeKey(key.toKeyProto());
        return this;
    }

    public TokenCreateTransaction setWipeKey(PublicKey key) {
        this.builder.setWipeKey(key.toKeyProto());
        return this;
    }

    public TokenCreateTransaction setSupplyKey(PublicKey key) {
        this.builder.setSupplyKey(key.toKeyProto());
        return this;
    }

    public TokenCreateTransaction setFreezeDefault(Boolean freeze) {
        this.builder.setFreezeDefault(freeze);
        return this;
    }

    public TokenCreateTransaction setExpirationTime(Instant expirationTime) {
        this.builder.setExpiry(expirationTime.getEpochSecond());
        return this;
    }

    public TokenCreateTransaction setAutoRenewAccount(AccountId account) {
        this.builder.setAutoRenewAccount(account.toProto());
        return this;
    }

    public TokenCreateTransaction setAutoRenewPeriod(Duration period) {
        this.builder.setAutoRenewPeriod(period.getSeconds());
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return TokenServiceGrpc.getCreateTokenMethod();
    }

    @Override
    protected void doValidate() {
    }
}

