/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.token;

import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TokenGetInfoQuery;
import com.hedera.hashgraph.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.token.TokenId;
import com.hedera.hashgraph.sdk.token.TokenInfo;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public final class TokenInfoQuery
extends QueryBuilder<TokenInfo, TokenInfoQuery> {
    private final TokenGetInfoQuery.Builder builder;

    public TokenInfoQuery() {
        this.builder = this.inner.getTokenGetInfoBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public TokenInfoQuery setTokenId(TokenId token) {
        this.builder.setToken(token.toProto());
        return this;
    }

    @Override
    protected void doValidate() {
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return TokenServiceGrpc.getGetTokenInfoMethod();
    }

    @Override
    protected TokenInfo extractResponse(Response raw) {
        return TokenInfo.fromResponse(raw);
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return Math.max(super.getCost(client), 25L);
    }

    @Override
    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        super.getCostAsync(client, cost -> withCost.accept(Math.min(cost, 25L)), onError);
    }
}

