/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.HbarRangeException;
import com.hedera.hashgraph.sdk.HbarUnit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public final class Hbar
implements Comparable<Hbar> {
    private final long tinybar;
    private final HbarUnit originalUnit;
    public static final Hbar ZERO = new Hbar(0L, HbarUnit.Hbar);
    public static final Hbar MIN = new Hbar(Long.MIN_VALUE, HbarUnit.Hbar);
    public static final Hbar MAX = new Hbar(Long.MAX_VALUE, HbarUnit.Hbar);

    public Hbar(long amount) {
        this.tinybar = Hbar.from((long)amount, (HbarUnit)HbarUnit.Hbar).tinybar;
        this.originalUnit = HbarUnit.Hbar;
    }

    public Hbar(BigDecimal amount) {
        this.tinybar = Hbar.from((BigDecimal)amount, (HbarUnit)HbarUnit.Hbar).tinybar;
        this.originalUnit = HbarUnit.Hbar;
    }

    private Hbar(long tinybar, HbarUnit originalUnit) {
        this.tinybar = tinybar;
        this.originalUnit = originalUnit;
    }

    public static Hbar from(long amount, HbarUnit unit) {
        try {
            return new Hbar(amount * unit.tinybar, unit);
        }
        catch (ArithmeticException e) {
            throw new HbarRangeException(amount + " " + (Object)((Object)unit) + " is out of range for Hbar");
        }
    }

    public static Hbar from(BigDecimal amount, HbarUnit unit) {
        BigInteger tinybar;
        if (unit == HbarUnit.Tinybar) {
            try {
                tinybar = amount.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new HbarRangeException("tinybar amount is not an integer: " + amount);
            }
        }
        BigDecimal tinybarDecimal = amount.multiply(new BigDecimal(unit.tinybar));
        try {
            tinybar = tinybarDecimal.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            throw new HbarRangeException("tinybar equivalent of " + amount + " " + (Object)((Object)unit) + " (" + tinybarDecimal + ") is not an integer");
        }
        try {
            return new Hbar(tinybar.longValueExact(), unit);
        }
        catch (ArithmeticException e) {
            throw new HbarRangeException(amount + " " + (Object)((Object)unit) + " is out of range for Hbar");
        }
    }

    public static Hbar fromTinybar(long amount) {
        return new Hbar(amount, HbarUnit.Tinybar);
    }

    @Deprecated
    public static Hbar of(long amount) {
        return Hbar.from(amount, HbarUnit.Hbar);
    }

    @Deprecated
    public static Hbar of(BigDecimal amount) {
        return Hbar.from(amount, HbarUnit.Hbar);
    }

    public BigDecimal as(HbarUnit unit) {
        if (unit == HbarUnit.Tinybar) {
            return new BigDecimal(this.tinybar);
        }
        return new BigDecimal(this.tinybar).divide(new BigDecimal(unit.tinybar), MathContext.UNLIMITED);
    }

    public long asTinybar() {
        return this.tinybar;
    }

    public Hbar negate() {
        return Hbar.fromTinybar(this.tinybar * -1L);
    }

    public String toString() {
        if (this.originalUnit != HbarUnit.Tinybar) {
            return this.as(this.originalUnit) + " " + this.originalUnit.getSymbol() + " (" + this.tinybar + " " + HbarUnit.Tinybar.getSymbol() + ")";
        }
        return this.tinybar + " " + HbarUnit.Tinybar.getSymbol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hbar hbar = (Hbar)o;
        return this.tinybar == hbar.tinybar;
    }

    public int hashCode() {
        return Long.hashCode(this.tinybar);
    }

    @Override
    public int compareTo(Hbar o) {
        return Long.compare(this.tinybar, o.tinybar);
    }
}

