/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.ResponseCodeEnum;
import com.hedera.hashgraph.proto.TransactionGetReceiptQuery;
import com.hedera.hashgraph.proto.TransactionGetReceiptResponse;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;

public class HederaReceiptStatusException
extends HederaStatusException {
    public final TransactionId transactionId;
    public final TransactionReceipt receipt;

    HederaReceiptStatusException(ResponseCodeEnum responseCode, TransactionId transactionId, TransactionReceipt receipt) {
        super(responseCode);
        this.transactionId = transactionId;
        this.receipt = receipt;
    }

    static boolean isCodeExceptional(ResponseCodeEnum responseCode) {
        return responseCode != ResponseCodeEnum.SUCCESS;
    }

    static void throwIfExceptional(TransactionGetReceiptQuery receiptQuery, TransactionGetReceiptResponse receiptResponse) throws HederaReceiptStatusException {
        ResponseCodeEnum status = receiptResponse.getReceipt().getStatus();
        if (HederaReceiptStatusException.isCodeExceptional(receiptResponse.getReceipt().getStatus())) {
            throw new HederaReceiptStatusException(status, new TransactionId(receiptQuery.getTransactionIDOrBuilder()), new TransactionReceipt(receiptResponse.getReceipt()));
        }
    }

    @Override
    public String getMessage() {
        return "receipt for transaction " + this.transactionId + " contained error status " + (Object)((Object)this.status);
    }
}

