/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.account.AccountId;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

class Node {
    final AccountId accountId;
    final String address;
    @Nullable
    private volatile ManagedChannel channel = null;

    Node(AccountId accountId, String address) {
        this.accountId = accountId;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        if (this.channel == null) {
            Node node = this;
            synchronized (node) {
                if (this.channel == null) {
                    this.channel = ManagedChannelBuilder.forTarget((String)this.address).usePlaintext().build();
                }
            }
        }
        return this.channel;
    }

    void closeChannel() {
        ManagedChannel channel = this.channel;
        if (channel != null) {
            channel.shutdown();
        }
    }

    void awaitChannelTermination(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        ManagedChannel channel = this.channel;
        if (channel != null && channel.shutdown().awaitTermination(timeout, timeUnit)) {
            throw new TimeoutException("Timed out waiting for node channel to shutdown: " + this.accountId + " :: " + this.address);
        }
    }
}

