/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.proto.AccountID;
import com.hedera.hashgraph.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.FreezeServiceGrpc;
import com.hedera.hashgraph.proto.SignatureMap;
import com.hedera.hashgraph.proto.SignatureMapOrBuilder;
import com.hedera.hashgraph.proto.SignaturePair;
import com.hedera.hashgraph.proto.SignaturePairOrBuilder;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionBody;
import com.hedera.hashgraph.proto.TransactionBodyOrBuilder;
import com.hedera.hashgraph.proto.TransactionID;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.HederaCall;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaPrecheckStatusException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PrivateKey;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.crypto.TransactionSigner;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.util.encoders.Hex;

public final class Transaction
extends HederaCall<com.hedera.hashgraph.proto.Transaction, TransactionResponse, TransactionId, Transaction> {
    static final Duration MAX_VALID_DURATION = Duration.ofMinutes(2L);
    private final MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> methodDescriptor;
    final Transaction.Builder inner;
    final AccountID nodeAccountId;
    final TransactionID txnIdProto;
    private final Duration validDuration;
    private static final int PREFIX_LEN = 6;
    public final TransactionId id;

    Transaction(Transaction.Builder inner, TransactionBodyOrBuilder body, MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> methodDescriptor) {
        this.inner = inner;
        this.nodeAccountId = body.getNodeAccountID();
        this.txnIdProto = body.getTransactionID();
        this.methodDescriptor = methodDescriptor;
        this.validDuration = DurationHelper.durationTo(body.getTransactionValidDuration());
        this.id = new TransactionId(this.txnIdProto);
    }

    public static Transaction fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        com.hedera.hashgraph.proto.Transaction inner = com.hedera.hashgraph.proto.Transaction.parseFrom(bytes);
        TransactionBody body = TransactionBody.parseFrom(inner.getBodyBytes());
        return new Transaction(inner.toBuilder(), body, Transaction.methodForTxnBody(body));
    }

    public Transaction sign(PrivateKey<? extends PublicKey> privateKey) {
        return this.signWith((PublicKey)privateKey.publicKey, privateKey::sign);
    }

    public Transaction signWith(PublicKey publicKey, TransactionSigner signer) {
        SignatureMap.Builder sigMap = this.inner.getSigMapBuilder();
        for (SignaturePair sigPair : sigMap.getSigPairList()) {
            ByteString pubKeyPrefix = sigPair.getPubKeyPrefix();
            if (!publicKey.hasPrefix(pubKeyPrefix)) continue;
            return this;
        }
        ByteString signatureBytes = ByteString.copyFrom((byte[])signer.signTransaction(this.inner.getBodyBytes().toByteArray()));
        SignaturePair.Builder sigPairBuilder = SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])publicKey.toBytes()));
        switch (publicKey.getSignatureCase()) {
            case CONTRACT: {
                throw new UnsupportedOperationException("contract signatures are not currently supported");
            }
            case ED25519: {
                sigPairBuilder.setEd25519(signatureBytes);
                break;
            }
            case RSA_3072: {
                sigPairBuilder.setRSA3072(signatureBytes);
                break;
            }
            case ECDSA_384: {
                sigPairBuilder.setECDSA384(signatureBytes);
                break;
            }
            case SIGNATURE_NOT_SET: {
                throw new IllegalStateException("PublicKey.getSignatureCase() returned SIGNATURE_NOT_SET");
            }
        }
        sigMap.addSigPair(sigPairBuilder);
        return this;
    }

    public byte[] hash() {
        if (this.nodeAccountId == null) {
            throw new IllegalStateException("transaction must have node id set");
        }
        if (this.inner.getSigMap().getSigPairList().size() == 0) {
            throw new IllegalStateException("transaction must be signed");
        }
        SHA384Digest digest = new SHA384Digest();
        byte[] hash = new byte[digest.getDigestSize()];
        byte[] bytes = this.toBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    @Override
    public final TransactionId execute(Client client, Duration timeout) throws HederaStatusException, HederaNetworkException, LocalValidationException {
        if (client.getOperatorPublicKey() != null && client.getOperatorSigner() != null && client.getOperatorId() != null && client.getOperatorId().equals(new AccountId(this.txnIdProto.getAccountID()))) {
            this.signWith(client.getOperatorPublicKey(), client.getOperatorSigner());
        }
        return (TransactionId)super.execute(client, timeout);
    }

    @Override
    public void executeAsync(Client client, Duration retryTimeout, Consumer<TransactionId> onSuccess, Consumer<HederaThrowable> onError) {
        if (client.getOperatorPublicKey() != null && client.getOperatorSigner() != null && client.getOperatorId() != null && client.getOperatorId().equals(new AccountId(this.txnIdProto.getAccountID()))) {
            this.signWith(client.getOperatorPublicKey(), client.getOperatorSigner());
        }
        super.executeAsync(client, retryTimeout, onSuccess, onError);
    }

    @Deprecated
    public TransactionReceipt getReceipt(Client client) throws HederaStatusException {
        return this.id.getReceipt(client);
    }

    @Deprecated
    public TransactionReceipt getReceipt(Client client, Duration timeout) throws HederaStatusException {
        return this.id.getReceipt(client, timeout);
    }

    @Deprecated
    public void getReceiptAsync(Client client, Consumer<TransactionReceipt> onReceipt, Consumer<HederaThrowable> onError) {
        this.id.getReceiptAsync(client, onReceipt, onError);
    }

    @Deprecated
    public void getReceiptAsync(Client client, Duration timeout, Consumer<TransactionReceipt> onReceipt, Consumer<HederaThrowable> onError) {
        this.id.getReceiptAsync(client, timeout, onReceipt, onError);
    }

    @Deprecated
    public TransactionRecord getRecord(Client client) throws HederaStatusException, HederaNetworkException {
        return this.id.getRecord(client);
    }

    @Deprecated
    public TransactionRecord getRecord(Client client, Duration timeout) throws HederaStatusException {
        return this.id.getRecord(client, timeout);
    }

    @Deprecated
    public void getRecordAsync(Client client, Consumer<TransactionRecord> onRecord, Consumer<HederaThrowable> onError) {
        this.id.getRecordAsync(client, onRecord, onError);
    }

    @Deprecated
    public void getRecordAsync(Client client, Duration timeout, Consumer<TransactionRecord> onRecord, Consumer<HederaThrowable> onError) {
        this.id.getRecordAsync(client, timeout, onRecord, onError);
    }

    @Override
    public com.hedera.hashgraph.proto.Transaction toProto() {
        return this.inner.build();
    }

    @Internal
    public com.hedera.hashgraph.proto.Transaction toProto(boolean requireSignature) {
        return this.inner.build();
    }

    @Override
    protected MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> getMethod() {
        return this.methodDescriptor;
    }

    @Override
    protected Channel getChannel(Client client) {
        Node channel = client.getNodeForId(new AccountId(this.nodeAccountId));
        Objects.requireNonNull(channel, "Transaction.nodeAccountId not found on Client");
        return channel.getChannel();
    }

    @Override
    protected final void localValidate() {
        SignatureMapOrBuilder sigMap = this.inner.getSigMapOrBuilder();
        if (sigMap.getSigPairCount() < 2) {
            if (sigMap.getSigPairCount() == 0) {
                this.addValidationError("Transaction requires at least one signature");
            }
        } else {
            HashSet<ByteString> publicKeys = new HashSet<ByteString>();
            for (int i = 0; i < sigMap.getSigPairCount(); ++i) {
                SignaturePairOrBuilder sig = sigMap.getSigPairOrBuilder(i);
                ByteString pubKeyPrefix = sig.getPubKeyPrefix();
                if (publicKeys.add(pubKeyPrefix)) continue;
                this.addValidationError("duplicate signing key: " + Hex.toHexString((byte[])Transaction.getPrefix(pubKeyPrefix).toByteArray()) + "...");
            }
        }
        this.checkValidationErrors("Transaction failed validation");
    }

    protected void validate(boolean requireSignature) {
        if (requireSignature) {
            this.localValidate();
            return;
        }
        this.checkValidationErrors("Transaction failed validation");
    }

    @Override
    protected TransactionId mapResponse(TransactionResponse response) throws HederaStatusException {
        HederaPrecheckStatusException.throwIfExceptional(response.getNodeTransactionPrecheckCode(), this.id);
        return new TransactionId(this.txnIdProto);
    }

    @Override
    protected Duration getDefaultTimeout() {
        return this.validDuration;
    }

    public byte[] toBytes() {
        return this.toProto().toByteArray();
    }

    @Deprecated
    public byte[] toBytes(boolean requiresSignature) {
        return this.toProto(requiresSignature).toByteArray();
    }

    private static ByteString getPrefix(ByteString byteString) {
        if (byteString.size() <= 6) {
            return byteString;
        }
        return byteString.substring(0, 6);
    }

    private static MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> methodForTxnBody(TransactionBodyOrBuilder body) {
        switch (body.getDataCase()) {
            case SYSTEMDELETE: {
                return FileServiceGrpc.getSystemDeleteMethod();
            }
            case SYSTEMUNDELETE: {
                return FileServiceGrpc.getSystemUndeleteMethod();
            }
            case FREEZE: {
                return FreezeServiceGrpc.getFreezeMethod();
            }
            case CONTRACTCALL: {
                return SmartContractServiceGrpc.getContractCallMethodMethod();
            }
            case CONTRACTCREATEINSTANCE: {
                return SmartContractServiceGrpc.getCreateContractMethod();
            }
            case CONTRACTUPDATEINSTANCE: {
                return SmartContractServiceGrpc.getUpdateContractMethod();
            }
            case CONTRACTDELETEINSTANCE: {
                return SmartContractServiceGrpc.getDeleteContractMethod();
            }
            case CRYPTOCREATEACCOUNT: {
                return CryptoServiceGrpc.getCreateAccountMethod();
            }
            case CRYPTODELETE: {
                return CryptoServiceGrpc.getCryptoDeleteMethod();
            }
            case CRYPTOTRANSFER: {
                return CryptoServiceGrpc.getCryptoTransferMethod();
            }
            case CRYPTOUPDATEACCOUNT: {
                return CryptoServiceGrpc.getUpdateAccountMethod();
            }
            case FILEAPPEND: {
                return FileServiceGrpc.getAppendContentMethod();
            }
            case FILECREATE: {
                return FileServiceGrpc.getCreateFileMethod();
            }
            case FILEDELETE: {
                return FileServiceGrpc.getDeleteFileMethod();
            }
            case FILEUPDATE: {
                return FileServiceGrpc.getUpdateFileMethod();
            }
            case CONSENSUSCREATETOPIC: {
                return ConsensusServiceGrpc.getCreateTopicMethod();
            }
            case CONSENSUSUPDATETOPIC: {
                return ConsensusServiceGrpc.getUpdateTopicMethod();
            }
            case CONSENSUSDELETETOPIC: {
                return ConsensusServiceGrpc.getDeleteTopicMethod();
            }
            case CONSENSUSSUBMITMESSAGE: {
                return ConsensusServiceGrpc.getSubmitMessageMethod();
            }
            case DATA_NOT_SET: {
                throw new IllegalArgumentException("method not set");
            }
        }
        throw new IllegalArgumentException("unsupported method");
    }
}

