/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionBody;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaCall;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.account.AccountId;
import io.grpc.Channel;
import java.time.Duration;
import javax.annotation.Nullable;

public abstract class TransactionBuilder<Resp, O, T extends TransactionBuilder<Resp, O, T>>
extends HederaCall<com.hedera.hashgraph.proto.Transaction, TransactionResponse, Resp, T> {
    protected final Transaction.Builder inner = com.hedera.hashgraph.proto.Transaction.newBuilder();
    protected final TransactionBody.Builder bodyBuilder = TransactionBody.newBuilder();
    private static final int MAX_MEMO_LENGTH = 100;
    private Duration validDuration;

    public TransactionBuilder() {
        this.setTransactionValidDuration(Transaction.MAX_VALID_DURATION);
        this.validDuration = Transaction.MAX_VALID_DURATION;
    }

    public T setTransactionId(TransactionId transactionId) {
        this.bodyBuilder.setTransactionID(transactionId.toProto());
        return this.self();
    }

    public final T setNodeAccountId(AccountId accountId) {
        this.bodyBuilder.setNodeAccountID(accountId.toProto());
        return this.self();
    }

    public final T setMaxTransactionFee(Hbar fee) {
        this.bodyBuilder.setTransactionFee(fee.asTinybar());
        return this.self();
    }

    public final T setMaxTransactionFee(long fee) {
        this.bodyBuilder.setTransactionFee(fee);
        return this.self();
    }

    public final T setTransactionValidDuration(Duration validDuration) {
        Duration actual = validDuration;
        if (Transaction.MAX_VALID_DURATION.compareTo(validDuration) < 0) {
            actual = Transaction.MAX_VALID_DURATION;
        }
        this.bodyBuilder.setTransactionValidDuration(DurationHelper.durationFrom(actual));
        this.validDuration = actual;
        return this.self();
    }

    public final T setTransactionMemo(String memo) {
        if (memo.length() > 100) {
            throw new IllegalArgumentException("memo must not be longer than 100 characters");
        }
        this.bodyBuilder.setMemo(memo);
        return this.self();
    }

    protected abstract void doValidate();

    @Override
    protected final void localValidate() {
        TransactionBody.Builder bodyBuilder = this.bodyBuilder;
        this.require(bodyBuilder.hasTransactionID(), ".setTransactionId() required");
        this.require(bodyBuilder.hasNodeAccountID(), ".setNodeAccountId() required");
        this.doValidate();
        this.checkValidationErrors("transaction builder failed local validation");
    }

    public abstract O build(@Nullable Client var1) throws LocalValidationException;

    private T self() {
        return (T)this;
    }

    @Override
    protected Duration getDefaultTimeout() {
        return this.validDuration;
    }

    @Override
    protected Channel getChannel(Client client) {
        if (this.bodyBuilder.hasNodeAccountID()) {
            return client.getNodeForId(new AccountId(this.bodyBuilder.getNodeAccountID())).getChannel();
        }
        return client.pickNode().getChannel();
    }

    @Override
    protected abstract Resp mapResponse(TransactionResponse var1) throws HederaStatusException;
}

