/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.crypto.PrivateKey;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.crypto.TransactionSigner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransactionList {
    private final Collection<Transaction> transactions;

    @Internal
    public TransactionList(Collection<Transaction> transactions) {
        this.transactions = transactions;
    }

    public TransactionList sign(PrivateKey<? extends PublicKey> privateKey) {
        return this.signWith((PublicKey)privateKey.publicKey, privateKey::sign);
    }

    public TransactionList signWith(PublicKey publicKey, TransactionSigner signer) {
        for (Transaction transaction : this.transactions) {
            transaction.signWith(publicKey, signer);
        }
        return this;
    }

    public final TransactionId execute(Client client) throws HederaStatusException, HederaNetworkException, LocalValidationException {
        return this.executeAll(client).get(0);
    }

    public final List<TransactionId> executeAll(Client client) throws HederaStatusException, HederaNetworkException, LocalValidationException {
        ArrayList<TransactionId> ids = new ArrayList<TransactionId>();
        for (Transaction transaction : this.transactions) {
            ids.add((TransactionId)transaction.execute(client));
        }
        return ids;
    }
}

