/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoCreateTransactionBody;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaConstants;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import io.grpc.MethodDescriptor;
import java.time.Duration;

public final class AccountCreateTransaction
extends SingleTransactionBuilder<AccountCreateTransaction> {
    private final CryptoCreateTransactionBody.Builder builder;

    public AccountCreateTransaction() {
        this.builder = this.bodyBuilder.getCryptoCreateAccountBuilder().setAutoRenewPeriod(DurationHelper.durationFrom(HederaConstants.DEFAULT_AUTORENEW_DURATION)).setSendRecordThreshold(Long.MAX_VALUE).setReceiveRecordThreshold(Long.MAX_VALUE);
    }

    public AccountCreateTransaction setKey(PublicKey publicKey) {
        this.builder.setKey(publicKey.toKeyProto());
        return this;
    }

    public AccountCreateTransaction setInitialBalance(long initialBalance) {
        this.builder.setInitialBalance(initialBalance);
        return this;
    }

    public AccountCreateTransaction setInitialBalance(Hbar initialBalance) {
        this.builder.setInitialBalance(initialBalance.asTinybar());
        return this;
    }

    public AccountCreateTransaction setProxyAccountId(AccountId accountId) {
        this.builder.setProxyAccountID(accountId.toProto());
        return this;
    }

    @Deprecated
    public AccountCreateTransaction setSendRecordThreshold(long sendRecordThreshold) {
        this.builder.setSendRecordThreshold(sendRecordThreshold);
        return this;
    }

    @Deprecated
    public AccountCreateTransaction setSendRecordThreshold(Hbar sendRecordThreshold) {
        this.builder.setSendRecordThreshold(sendRecordThreshold.asTinybar());
        return this;
    }

    @Deprecated
    public AccountCreateTransaction setReceiveRecordThreshold(long receiveRecordThreshold) {
        this.builder.setReceiveRecordThreshold(receiveRecordThreshold);
        return this;
    }

    @Deprecated
    public AccountCreateTransaction setReceiveRecordThreshold(Hbar receiveRecordThreshold) {
        this.builder.setReceiveRecordThreshold(receiveRecordThreshold.asTinybar());
        return this;
    }

    public AccountCreateTransaction setReceiverSignatureRequired(boolean receiverSignatureRequired) {
        this.builder.setReceiverSigRequired(receiverSignatureRequired);
        return this;
    }

    public AccountCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(autoRenewPeriod));
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasKey(), ".setKey() required");
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return CryptoServiceGrpc.getCreateAccountMethod();
    }
}

