/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.AccountID;
import com.hedera.hashgraph.proto.AccountIDOrBuilder;
import com.hedera.hashgraph.sdk.IdUtil;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.SolidityUtil;
import java.util.Objects;

public final class AccountId {
    public final long shard;
    public final long realm;
    public final long account;

    public AccountId(long accountNum) {
        this(0L, 0L, accountNum);
    }

    public AccountId(long shard, long realm, long account) {
        this.shard = shard;
        this.realm = realm;
        this.account = account;
    }

    public static AccountId fromString(String account) throws IllegalArgumentException {
        return IdUtil.parseIdString(account, AccountId::new);
    }

    public AccountId(AccountIDOrBuilder accountId) {
        this(accountId.getShardNum(), accountId.getRealmNum(), accountId.getAccountNum());
    }

    public static AccountId fromSolidityAddress(String address) {
        return SolidityUtil.parseAddress(address, AccountId::new);
    }

    public String toString() {
        return "" + this.shard + "." + this.realm + "." + this.account;
    }

    public String toSolidityAddress() {
        return SolidityUtil.addressFor(this);
    }

    @Internal
    public AccountID toProto() {
        return AccountID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setAccountNum(this.account).build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AccountId otherId = (AccountId)other;
        return otherId.account == this.account && otherId.realm == this.realm && otherId.shard == this.shard;
    }

    public int hashCode() {
        return Objects.hash(this.account, this.realm, this.shard);
    }
}

