/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.proto.CryptoGetInfoResponse;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.account.TokenRelationship;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.token.TokenId;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class AccountInfo {
    public final AccountId accountId;
    public final String contractAccountId;
    public final boolean isDeleted;
    @Nullable
    public final AccountId proxyAccountId;
    public final long proxyReceived;
    public final PublicKey key;
    public final long balance;
    public final long generateSendRecordThreshold;
    public final long generateReceiveRecordThreshold;
    public final boolean isReceiverSignatureRequired;
    public final Instant expirationTime;
    public final Duration autoRenewPeriod;
    public final Map<TokenId, TokenRelationship> tokenRelationships;

    AccountInfo(CryptoGetInfoResponse.AccountInfoOrBuilder info) {
        if (!info.hasKey()) {
            throw new IllegalArgumentException("query response missing key");
        }
        this.accountId = new AccountId(info.getAccountIDOrBuilder());
        this.contractAccountId = info.getContractAccountID();
        this.isDeleted = info.getDeleted();
        this.proxyAccountId = info.hasProxyAccountID() ? new AccountId(info.getProxyAccountIDOrBuilder()) : null;
        this.proxyReceived = info.getProxyReceived();
        this.key = PublicKey.fromProtoKey(info.getKeyOrBuilder());
        this.balance = info.getBalance();
        this.generateSendRecordThreshold = info.getGenerateSendRecordThreshold();
        this.generateReceiveRecordThreshold = info.getGenerateReceiveRecordThreshold();
        this.isReceiverSignatureRequired = info.getReceiverSigRequired();
        this.expirationTime = TimestampHelper.timestampTo(info.getExpirationTime());
        this.autoRenewPeriod = DurationHelper.durationTo(info.getAutoRenewPeriod());
        HashMap<TokenId, TokenRelationship> relationships = new HashMap<TokenId, TokenRelationship>();
        for (com.hedera.hashgraph.proto.TokenRelationship relationship : info.getTokenRelationshipsList()) {
            TokenId tokenId = new TokenId(relationship.getTokenId());
            relationships.put(tokenId, new TokenRelationship(relationship));
        }
        this.tokenRelationships = Collections.unmodifiableMap(relationships);
    }

    static AccountInfo fromResponse(Response response) {
        if (!response.hasCryptoGetInfo()) {
            throw new IllegalArgumentException("query response was not `CryptoGetInfoResponse`");
        }
        CryptoGetInfoResponse infoResponse = response.getCryptoGetInfo();
        return new AccountInfo(infoResponse.getAccountInfo());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountId", (Object)this.accountId).add("contractAccountId", (Object)this.contractAccountId).add("isDeleted", this.isDeleted).add("proxyAccountId", (Object)this.proxyAccountId).add("proxyReceived", this.proxyReceived).add("key", (Object)this.key).add("balance", this.balance).add("generateSendRecordThreshold", this.generateSendRecordThreshold).add("generateReceiveRecordThreshold", this.generateReceiveRecordThreshold).add("isReceiverSignatureRequired", this.isReceiverSignatureRequired).add("expirationTime", (Object)this.expirationTime).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("tokenRelationships", this.tokenRelationships).toString();
    }
}

