/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoGetInfoQuery;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.account.AccountInfo;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public final class AccountInfoQuery
extends QueryBuilder<AccountInfo, AccountInfoQuery> {
    private final CryptoGetInfoQuery.Builder builder;

    public AccountInfoQuery() {
        this.builder = this.inner.getCryptoGetInfoBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public AccountInfoQuery setAccountId(AccountId account) {
        this.builder.setAccountID(account.toProto());
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasAccountID(), ".setAccountId() required");
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getGetAccountInfoMethod();
    }

    @Override
    protected AccountInfo extractResponse(Response raw) {
        return AccountInfo.fromResponse(raw);
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return Math.max(super.getCost(client), 25L);
    }

    @Override
    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        super.getCostAsync(client, cost -> withCost.accept(Math.min(cost, 25L)), onError);
    }
}

