/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.CryptoGetAccountRecordsQuery;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.account.AccountId;
import io.grpc.MethodDescriptor;
import java.util.List;
import java.util.stream.Collectors;

public final class AccountRecordsQuery
extends QueryBuilder<List<TransactionRecord>, AccountRecordsQuery> {
    private final CryptoGetAccountRecordsQuery.Builder builder;

    public AccountRecordsQuery() {
        this.builder = this.inner.getCryptoGetAccountRecordsBuilder();
    }

    public AccountRecordsQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProto());
        return this;
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasAccountID(), ".setAccountId() required");
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return CryptoServiceGrpc.getGetAccountRecordsMethod();
    }

    @Override
    protected List<TransactionRecord> extractResponse(Response raw) {
        return raw.getCryptoGetAccountRecords().getRecordsList().stream().map(TransactionRecord::new).collect(Collectors.toList());
    }
}

