/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.account;

import com.hedera.hashgraph.proto.AccountAmount;
import com.hedera.hashgraph.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.proto.CryptoTransferTransactionBody;
import com.hedera.hashgraph.proto.TokenTransferList;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.proto.TransferList;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.token.TokenId;
import io.grpc.MethodDescriptor;
import java.util.HashMap;

public final class TransferTransaction
extends SingleTransactionBuilder<TransferTransaction> {
    private final CryptoTransferTransactionBody.Builder builder;
    private final TransferList.Builder transferList;
    private HashMap<TokenId, Integer> tokenIndexes;

    public TransferTransaction() {
        this.builder = this.bodyBuilder.getCryptoTransferBuilder();
        this.transferList = this.builder.getTransfersBuilder();
        this.tokenIndexes = new HashMap();
    }

    public TransferTransaction addHbarTransfer(AccountId accountId, Hbar value) {
        return this.addHbarTransfer(accountId, value.asTinybar());
    }

    public TransferTransaction addHbarTransfer(AccountId accountId, long value) {
        this.transferList.addAccountAmounts(AccountAmount.newBuilder().setAccountID(accountId.toProto()).setAmount(value).build());
        return this;
    }

    public TransferTransaction addTokenTransfer(TokenId tokenId, AccountId accountId, long amount) {
        TokenTransferList.Builder transfers;
        Integer index = this.tokenIndexes.get(tokenId);
        int size = this.builder.getTokenTransfersCount();
        if (index != null) {
            transfers = this.builder.getTokenTransfersBuilder(index);
        } else {
            this.builder.addTokenTransfers(TokenTransferList.newBuilder());
            transfers = this.builder.getTokenTransfersBuilder(size);
            this.tokenIndexes.put(tokenId, size);
        }
        transfers.setToken(tokenId.toProto());
        transfers.addTransfers(AccountAmount.newBuilder().setAccountID(accountId.toProto()).setAmount(amount));
        return this;
    }

    @Override
    protected void doValidate() {
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return CryptoServiceGrpc.getCryptoTransferMethod();
    }
}

