/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.google.common.collect.Iterators;
import com.hedera.hashgraph.proto.mirror.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicQuery;
import com.hedera.hashgraph.proto.mirror.ConsensusTopicResponse;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.consensus.ConsensusMessage;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;

@Deprecated
public class ConsensusClient
implements AutoCloseable {
    private final ManagedChannel channel;
    @Nullable
    private Consumer<Throwable> errorHandler;

    public ConsensusClient(String endpoint) {
        this.channel = ManagedChannelBuilder.forTarget((String)endpoint).keepAliveTime(2L, TimeUnit.MINUTES).usePlaintext().build();
    }

    public ConsensusClient setErrorHandler(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Subscription subscribe(ConsensusTopicId topicId, Consumer<ConsensusMessage> listener) {
        return this.startStreamingCall(topicId, null, listener);
    }

    public Subscription subscribe(ConsensusTopicId topicId, Instant consensusStartTime, Consumer<ConsensusMessage> listener) {
        return this.startStreamingCall(topicId, consensusStartTime, listener);
    }

    private Subscription startStreamingCall(final ConsensusTopicId topicId, @Nullable Instant startTime, final Consumer<ConsensusMessage> listener) {
        ClientCall call = this.channel.newCall(ConsensusServiceGrpc.getSubscribeTopicMethod(), CallOptions.DEFAULT);
        ConsensusTopicQuery.Builder topicQuery = ConsensusTopicQuery.newBuilder().setTopicID(topicId.toProto());
        if (startTime != null) {
            topicQuery.setConsensusStartTime(TimestampHelper.timestampFrom(startTime));
        }
        Subscription subscription = new Subscription(topicId, startTime, call);
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)topicQuery.build(), (StreamObserver)new StreamObserver<ConsensusTopicResponse>(){

            public void onNext(ConsensusTopicResponse message) {
                listener.accept(new ConsensusMessage(topicId, message));
            }

            public void onError(Throwable t) {
                if (ConsensusClient.this.errorHandler != null) {
                    ConsensusClient.this.errorHandler.accept(t);
                }
            }

            public void onCompleted() {
            }
        });
        return subscription;
    }

    public Iterator<ConsensusMessage> getMessages(ConsensusTopicId topicId, Instant startTime, Instant endTime) {
        ConsensusTopicQuery topicQuery = ConsensusTopicQuery.newBuilder().setTopicID(topicId.toProto()).setConsensusStartTime(TimestampHelper.timestampFrom(startTime)).setConsensusEndTime(TimestampHelper.timestampFrom(endTime)).build();
        Iterator iter = ClientCalls.blockingServerStreamingCall((Channel)this.channel, ConsensusServiceGrpc.getSubscribeTopicMethod(), (CallOptions)CallOptions.DEFAULT, (Object)topicQuery);
        return Iterators.transform((Iterator)iter, message -> new ConsensusMessage(topicId, Objects.requireNonNull(message)));
    }

    public Iterator<ConsensusMessage> getMessagesUntil(ConsensusTopicId topicId, Instant endTime) {
        ConsensusTopicQuery topicQuery = ConsensusTopicQuery.newBuilder().setTopicID(topicId.toProto()).setConsensusEndTime(TimestampHelper.timestampFrom(endTime)).build();
        Iterator iter = ClientCalls.blockingServerStreamingCall((Channel)this.channel, ConsensusServiceGrpc.getSubscribeTopicMethod(), (CallOptions)CallOptions.DEFAULT, (Object)topicQuery);
        return Iterators.transform((Iterator)iter, message -> new ConsensusMessage(topicId, Objects.requireNonNull(message)));
    }

    @Override
    public void close() throws InterruptedException {
        this.close(5L, TimeUnit.SECONDS);
    }

    public boolean close(long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        this.channel.shutdownNow();
        return this.channel.awaitTermination(timeout, timeoutUnit);
    }

    public static final class Subscription {
        private final ClientCall<ConsensusTopicQuery, ConsensusTopicResponse> call;
        public final ConsensusTopicId topicId;
        @Nullable
        public final Instant consensusStartTime;

        private Subscription(ConsensusTopicId topicId, @Nullable Instant startTime, ClientCall<ConsensusTopicQuery, ConsensusTopicResponse> call) {
            this.call = call;
            this.topicId = topicId;
            this.consensusStartTime = startTime;
        }

        public void unsubscribe() {
            this.call.cancel("unsubscribed from topic", null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Subscription that = (Subscription)o;
            return this.topicId.equals(that.topicId) && Objects.equals(this.consensusStartTime, that.consensusStartTime);
        }

        public int hashCode() {
            return Objects.hash(this.topicId, this.consensusStartTime);
        }
    }
}

